/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.internal.server.PackageManager;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.RepositoryNotFoundException;
import org.eclipse.emf.cdo.server.SessionCreationException;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class OpenSessionIndication
extends IndicationWithResponse {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionIndication.class);
    private String repositoryName;
    private boolean legacySupportEnabled;

    protected short getSignalID() {
        return 1;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        this.repositoryName = in.readString();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read repositoryName: {0}", new Object[]{this.repositoryName});
        }
        this.legacySupportEnabled = in.readBoolean();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read legacySupportEnabled: {0}", new Object[]{this.legacySupportEnabled});
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        try {
            Repository repository = this.getRepository();
            SessionManager sessionManager = repository.getSessionManager();
            CDOServerProtocol serverProtocol = (CDOServerProtocol)this.getProtocol();
            Session session = sessionManager.openSession(serverProtocol, this.legacySupportEnabled);
            serverProtocol.setInfraStructure(session);
            this.writeSessionID(out, session);
            this.writeRepositoryUUID(out, repository);
            repository.getStore().getCDOIDLibraryDescriptor().write((ExtendedDataOutput)out);
            this.writePackages(out, repository.getPackageManager());
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Repository {0} not found", new Object[]{this.repositoryName});
            }
            out.writeInt(-1);
        }
        catch (SessionCreationException sessionCreationException) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Failed to open session for repository {0}", new Object[]{this.repositoryName});
            }
            out.writeInt(-2);
            return;
        }
    }

    private Repository getRepository() {
        try {
            CDOServerProtocol protocol = (CDOServerProtocol)this.getProtocol();
            IRepositoryProvider repositoryProvider = (IRepositoryProvider)protocol.getInfraStructure();
            return (Repository)repositoryProvider.getRepository(this.repositoryName);
        }
        catch (RuntimeException runtimeException) {
            throw new RepositoryNotFoundException(this.repositoryName);
        }
    }

    private void writeSessionID(ExtendedDataOutputStream out, ISession session) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing sessionID: {0}", new Object[]{session.getSessionID()});
        }
        out.writeInt(session.getSessionID());
    }

    private void writeRepositoryUUID(ExtendedDataOutputStream out, IRepository repository) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing repositoryUUID: {0}", new Object[]{repository.getUUID()});
        }
        out.writeString(repository.getUUID());
    }

    private void writePackages(ExtendedDataOutputStream out, PackageManager packageManager) throws IOException {
        CDOPackage[] packages;
        CDOPackage[] cDOPackageArray = packages = packageManager.getPackages();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackage p = cDOPackageArray[n2];
            if (!p.isSystem()) {
                if (PROTOCOL.isEnabled()) {
                    PROTOCOL.format("Writing package info: uri={0}, dynamic={1}, metaIDRange={2}, parentURI={3}", new Object[]{p.getPackageURI(), p.isDynamic(), p.getMetaIDRange(), p.getParentURI()});
                }
                out.writeString(p.getPackageURI());
                out.writeBoolean(p.isDynamic());
                CDOIDUtil.writeMetaRange((ExtendedDataOutput)out, (CDOIDMetaRange)p.getMetaIDRange());
                out.writeString(p.getParentURI());
            }
            ++n2;
        }
        out.writeString(null);
    }
}

