/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import org.eclipse.net4j.util.ref.KeyedReference;
import org.eclipse.net4j.util.ref.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedWeakReference<K, T>
extends WeakReference<T>
implements KeyedReference<K, T> {
    private K key;

    public KeyedWeakReference(K key, T ref) {
        super(ref);
        this.key = key;
    }

    public KeyedWeakReference(K key, T ref, ReferenceQueue<T> queue) {
        super(ref, queue);
        this.key = key;
    }

    @Override
    public ReferenceType getType() {
        return ReferenceType.WEAK;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public String toString() {
        return MessageFormat.format("KeyedWeakReference[{0} -> {1}]", this.key, this.isEnqueued() ? "ENQUEUED" : this.get());
    }
}

