/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.adapter.AbstractAdapter;
import org.eclipse.net4j.examples.mvc.adapter.AbstractRecordModelAdapter;
import org.eclipse.net4j.examples.mvc.aspect.IMetaDataAspect;
import org.eclipse.net4j.examples.mvc.aspect.IRecordModelAspect;
import org.eclipse.net4j.examples.mvc.util.NoTargetException;
import org.eclipse.net4j.examples.mvc.util.UnknownFieldException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectRecordModelAdapter
extends AbstractRecordModelAdapter<EObject> {
    private String[] cachedFieldNames;
    private Adapter eAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            Object feature = msg.getFeature();
            if (feature instanceof EStructuralFeature) {
                String fieldName = ((EStructuralFeature)feature).getName();
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        EObjectRecordModelAdapter.this.onSet(fieldName, msg.getNewValue(), msg.getOldValue());
                        break;
                    }
                    case 3: {
                        EObjectRecordModelAdapter.this.onAdd(fieldName, msg.getOldValue(), msg.getPosition());
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        EObjectRecordModelAdapter.this.onRemove(fieldName, msg.getOldValue(), msg.getPosition());
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        EObjectRecordModelAdapter.this.onMove(fieldName, msg.getOldIntValue(), msg.getPosition());
                    }
                }
            }
            msg.getOldValue();
            msg.getNewValue();
        }
    };

    public EObjectRecordModelAdapter(Factory factory) {
        super(factory);
    }

    @Override
    public int getFieldCount() throws NoTargetException {
        return this.getFieldNames().length;
    }

    @Override
    public String[] getFieldNames() throws NoTargetException {
        if (this.getTarget() == null) {
            throw new NoTargetException();
        }
        if (this.cachedFieldNames == null) {
            ArrayList<String> names = new ArrayList<String>();
            EList fields = ((EObject)this.getTarget()).eClass().getEAllStructuralFeatures();
            for (Object field : fields) {
                EStructuralFeature feature = (EStructuralFeature)field;
                names.add(feature.getName());
            }
            this.cachedFieldNames = names.toArray(new String[fields.size()]);
        }
        return this.cachedFieldNames;
    }

    @Override
    public Class getFieldType(String fieldName) {
        return this.getFeature(fieldName).getEType().getInstanceClass();
    }

    @Override
    public Object[] getMetaDataKeys() {
        EList data = ((EObject)this.getTarget()).eClass().getEAnnotations();
        Object[] result = new Object[data.size()];
        Iterator it = data.iterator();
        int i = 0;
        while (i < data.size()) {
            EAnnotation annotation = (EAnnotation)it.next();
            result[i] = annotation.getSource();
            ++i;
        }
        return result;
    }

    @Override
    public Object getMetaData(Object key) {
        return ((EObject)this.getTarget()).eClass().getEAnnotation((String)key);
    }

    @Override
    public Object getValue(String fieldName) {
        if (this.getTarget() == null) {
            throw new NoTargetException();
        }
        return ((EObject)this.getTarget()).eGet(this.getFeature(fieldName));
    }

    @Override
    public void setValue(String fieldName, Object value) {
        Object oldValue = this.getValue(fieldName);
        Object newValue = this.onVerify(fieldName, value);
        if (newValue == oldValue) {
            return;
        }
        ((EObject)this.getTarget()).eSet(this.getFeature(fieldName), newValue);
    }

    @Override
    protected void onRetarget() {
        this.cachedFieldNames = null;
    }

    @Override
    protected void connectTarget(Class aspect) {
        if (aspect == IRecordModelAspect.class) {
            ((EObject)this.getTarget()).eAdapters().add((Object)this.eAdapter);
        }
    }

    @Override
    protected void disconnectTarget(Class aspect) {
        if (aspect == IRecordModelAspect.class) {
            ((EObject)this.getTarget()).eAdapters().remove((Object)this.eAdapter);
        }
    }

    private EStructuralFeature getFeature(String fieldName) {
        if (this.getTarget() == null) {
            throw new NoTargetException();
        }
        EStructuralFeature feature = ((EObject)this.getTarget()).eClass().getEStructuralFeature(fieldName);
        if (feature == null) {
            throw new UnknownFieldException(fieldName);
        }
        return feature;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractAdapter.AbstractFactory<EObject> {
        private static final Class[] ASPECTS = new Class[]{IMetaDataAspect.class, IRecordModelAspect.class};
        private static final Class[] ADAPTABLE_CLASSES = new Class[]{EObject.class};

        @Override
        public IAdapter<EObject> createAdapter() {
            return new EObjectRecordModelAdapter(this);
        }

        @Override
        public Class[] getAspects() {
            return ASPECTS;
        }

        @Override
        public Class[] getAdaptableClasses() {
            return ADAPTABLE_CLASSES;
        }
    }
}

