/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.properties.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.ui.services.properties.descriptors.ICompositeSourcePropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class EMFCompositeSourcePropertyDescriptor
extends PropertyDescriptor
implements ICompositeSourcePropertyDescriptor {
    protected String category = null;
    protected String[] filterFlags;
    protected boolean readOnly = false;
    protected CellEditor propertyEditor = null;
    protected ICellEditorValidator validator;

    public static ILabelProvider createLabelProvider(IItemPropertyDescriptor itemPropertyDescriptor) {
        final IItemLabelProvider itemLabelProvider = itemPropertyDescriptor.getLabelProvider(null);
        return new LabelProvider(){

            public String getText(Object object) {
                return itemLabelProvider.getText(object);
            }

            public Image getImage(Object object) {
                return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage(object));
            }
        };
    }

    public EMFCompositeSourcePropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        super(object, itemPropertyDescriptor);
        this.filterFlags = itemPropertyDescriptor.getFilterFlags(object);
        this.filterFlags = this.filterFlags == null ? new String[]{} : this.filterFlags;
    }

    public EMFCompositeSourcePropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor, String category) {
        this(object, itemPropertyDescriptor);
        this.setCategory(category);
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        String aCategory = super.getCategory();
        return aCategory == null ? this.category : aCategory;
    }

    public String[] getFilterFlags() {
        return this.filterFlags;
    }

    public void addFilterFlag(String flag) {
        if (!Arrays.asList(this.filterFlags).contains(flag)) {
            String[] flags = new String[this.filterFlags.length + 1];
            System.arraycopy(this.filterFlags, 0, flags, 0, this.filterFlags.length);
            flags[this.filterFlags.length] = flag;
            this.filterFlags = flags;
        }
    }

    public CellEditor createPropertyEditor(Composite composite) {
        if (this.isReadOnly()) {
            return null;
        }
        if (this.getPropertyEditor() != null) {
            return this.getPropertyEditor();
        }
        return this.doCreateEditor(composite);
    }

    protected CellEditor doCreateEditor(Composite composite) {
        CellEditor result = null;
        Object genericFeature = this.getFeature();
        if (genericFeature instanceof EReference[]) {
            result = this.createComboBoxCellEditor(composite);
        } else if (genericFeature instanceof EStructuralFeature) {
            EDataType eDataType;
            EStructuralFeature feature = (EStructuralFeature)genericFeature;
            EClassifier eType = feature.getEType();
            List choiceOfValues = this.getChoiceOfValues();
            if (!choiceOfValues.isEmpty()) {
                if (this.getItemDescriptor().isMany(this.getObject())) {
                    boolean valid = true;
                    for (Object choice : choiceOfValues) {
                        if (eType.isInstance(choice)) continue;
                        valid = false;
                        break;
                    }
                    if (valid) {
                        result = this.createDialogCellEditor(composite, feature, choiceOfValues);
                    }
                }
                if (result == null) {
                    result = this.createComboBoxCellEditor(composite);
                }
            } else if (eType instanceof EDataType && (eDataType = (EDataType)eType).isSerializable()) {
                result = this.getItemDescriptor().isMany(this.getObject()) ? this.createDialogCellEditor(composite, feature, choiceOfValues) : (eDataType == EcorePackage.eINSTANCE.getEBoolean() || eDataType == EcorePackage.eINSTANCE.getEBooleanObject() || eDataType.getInstanceClass() == EcorePackage.eINSTANCE.getEBoolean().getInstanceClass() ? this.createBooleanCellEditor(composite) : this.createDataTypeCellEditor(composite));
            }
        }
        return result == null ? super.createPropertyEditor(composite) : result;
    }

    public boolean isReadOnly() {
        return !this.itemPropertyDescriptor.canSetProperty(this.object) || this.readOnly;
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        if (this == anotherProperty) {
            return true;
        }
        if (!(anotherProperty instanceof EMFCompositeSourcePropertyDescriptor)) {
            return false;
        }
        EMFCompositeSourcePropertyDescriptor descriptor = (EMFCompositeSourcePropertyDescriptor)anotherProperty;
        if (this.getFeature() == descriptor.getFeature()) {
            return this.getCategory().equals(descriptor.getCategory());
        }
        return false;
    }

    protected Object getObject() {
        return this.object;
    }

    public IItemPropertyDescriptor getItemDescriptor() {
        return this.itemPropertyDescriptor;
    }

    public Object getFeature() {
        return this.itemPropertyDescriptor.getFeature(this.getObject());
    }

    protected CellEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(CellEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public ICellEditorValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ICellEditorValidator validator) {
        this.validator = validator;
    }

    protected CellEditor createComboBoxCellEditor(Composite composite) {
        return new ExtendedComboBoxCellEditor(composite, new ArrayList(this.getChoiceOfValues()), this.getLabelProvider(), true);
    }

    protected CellEditor createDialogCellEditor(Composite composite, final EStructuralFeature feature, final List choiceOfValues) {
        return new ExtendedDialogCellEditor(composite, this.getEditLabelProvider()){

            protected Object openDialogBox(Control cellEditorWindow) {
                FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), EMFCompositeSourcePropertyDescriptor.this.getLabelProvider(), EMFCompositeSourcePropertyDescriptor.this.getObject(), feature.getEType(), (List)((IItemPropertySource)EMFCompositeSourcePropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(EMFCompositeSourcePropertyDescriptor.this.object)).getEditableValue(EMFCompositeSourcePropertyDescriptor.this.object), EMFCompositeSourcePropertyDescriptor.this.getDisplayName(), choiceOfValues);
                dialog.open();
                return dialog.getResult();
            }
        };
    }

    protected CellEditor createBooleanCellEditor(Composite composite) {
        return new ExtendedComboBoxCellEditor(composite, Arrays.asList(Boolean.FALSE, Boolean.TRUE), this.getLabelProvider(), true);
    }

    protected CellEditor createDataTypeCellEditor(Composite composite) {
        EClassifier eType;
        Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
        if (genericFeature instanceof EStructuralFeature && (eType = ((EStructuralFeature)genericFeature).getEType()) instanceof EDataType) {
            return new PropertyDescriptor.EDataTypeCellEditor((EDataType)eType, composite){

                protected void focusLost() {
                    if (this.isActivated()) {
                        this.deactivate();
                    }
                }
            };
        }
        return null;
    }

    public Object getPropertyValue() {
        return this.getEditableValue();
    }

    protected Object getEditableValue() {
        Object aValue = this.getItemDescriptor().getPropertyValue(this.getObject());
        IItemPropertySource itemSource = this.getPropertySource(aValue);
        if (itemSource != null) {
            aValue = itemSource.getEditableValue(aValue);
        }
        return aValue;
    }

    public void setPropertyValue(Object value) {
        Object oldValue = this.getEditableValue();
        if (oldValue != null && oldValue.equals(value) || oldValue == null && value == null) {
            return;
        }
        this.getItemDescriptor().setPropertyValue(this.getObject(), value);
    }

    public void resetPropertyValue() {
        this.getItemDescriptor().resetPropertyValue(this.getObject());
    }

    protected IItemPropertySource getPropertySource(Object value) {
        if (value instanceof IItemPropertySource) {
            return (IItemPropertySource)value;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)this.getObject());
        if (editingDomain instanceof AdapterFactoryEditingDomain) {
            return (IItemPropertySource)((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory().adapt(value, IItemPropertySource.class);
        }
        return null;
    }

    public Object getId() {
        return this.getFeature();
    }

    public List getChoiceOfValues() {
        Collection types = this.itemPropertyDescriptor.getChoiceOfValues(this.getObject());
        return types == null ? new ArrayList() : new ArrayList(types);
    }

    public void resetPropertyValue(Object value) {
        this.getItemDescriptor().resetPropertyValue(this.getObject());
    }
}

