/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update.canonical;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.commands.RemoveNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.commands.ReplaceNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.AbstractNotationModelRefresher;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.ElementDescriptor;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChildNotationModelRefresher
extends AbstractNotationModelRefresher {
    @Override
    public Command buildRefreshNotationModelCommand() {
        List<ElementDescriptor> semanticChildren = this.getSemanticChildNodes();
        EList notationalChildren = this.getHost().getChildren();
        if (semanticChildren.isEmpty() && notationalChildren.isEmpty()) {
            return null;
        }
        HashMap<EObject, View> semanticToNotational = new HashMap<EObject, View>();
        for (View next : notationalChildren) {
            EObject nextSemantic;
            if (!next.isSetElement() || (nextSemantic = next.getElement()) == null) continue;
            semanticToNotational.put(nextSemantic, next);
        }
        CompoundCommand command = new CompoundCommand();
        for (ElementDescriptor next : semanticChildren) {
            EObject node = next.getElement();
            View currentView = (View)semanticToNotational.remove(node);
            int nodeVisualID = next.getVisualID();
            if (currentView == null) {
                if (!this.shouldCreateView(next)) continue;
                command.appendIfCanExecute((Command)this.getCreateNotationalElementCommand(next));
                continue;
            }
            if (nodeVisualID == this.getVisualID(currentView)) continue;
            CreateNotationalElementCommand notationalCommand = this.getCreateNotationalElementCommand(next);
            if (notationalCommand != null) {
                command.appendIfCanExecute((Command)new ReplaceNotationalElementCommand(this.getHost(), notationalCommand, currentView));
                continue;
            }
            command.appendIfCanExecute((Command)new RemoveNotationalElementCommand(this.getHost(), currentView));
        }
        for (View obsoleteView : semanticToNotational.values()) {
            if (this.shouldRemoveView(obsoleteView)) {
                command.appendIfCanExecute((Command)new RemoveNotationalElementCommand(this.getHost(), obsoleteView));
                continue;
            }
            command.appendIfCanExecute(this.getRefreshExternalElementCommand(obsoleteView));
        }
        return command.getCommandList().isEmpty() ? null : command;
    }

    protected Command getRefreshExternalElementCommand(View externalView) {
        return null;
    }

    protected abstract List<ElementDescriptor> getSemanticChildNodes();

    protected boolean shouldRemoveView(View view) {
        return true;
    }
}

