/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.graph;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.CompositeDirectedGraphLayout;

public class CompositeGraphLayoutTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(CompositeGraphLayoutTest.class);
    }

    public void testVirtualNodeCreation() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node n2 = new Node((Object)"N2");
        nodes.add((Object)n2);
        Node n1 = new Node((Object)"N1");
        nodes.add((Object)n1);
        Node n3 = new Node((Object)"N3");
        nodes.add((Object)n3);
        Node n4 = new Node((Object)"N4");
        nodes.add((Object)n4);
        edges.add((Object)new Edge(n1, n4));
        edges.add((Object)new Edge(n2, n3));
        edges.add((Object)new Edge(n1, n2));
        edges.add((Object)new Edge(n3, n1));
        int X = n1.x;
        CompoundDirectedGraph g = new CompoundDirectedGraph();
        g.nodes = nodes;
        g.edges = edges;
        CompositeDirectedGraphLayout layout = new CompositeDirectedGraphLayout();
        layout.visit((DirectedGraph)g);
        CompositeGraphLayoutTest.assertTrue((n1.x != X ? 1 : 0) != 0);
    }

    public void testVirtualEdgeCreation() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph sg1 = new Subgraph((Object)"SubGraph1");
        nodes.add((Object)sg1);
        Node n1 = new Node((Object)"N1", sg1);
        nodes.add((Object)n1);
        Node n2 = new Node((Object)"N3");
        nodes.add((Object)n2);
        edges.add((Object)new Edge(n1, n2));
        CompoundDirectedGraph g = new CompoundDirectedGraph();
        int X = n1.x;
        g.nodes = nodes;
        g.edges = edges;
        CompositeDirectedGraphLayout layout = new CompositeDirectedGraphLayout();
        layout.visit((DirectedGraph)g);
        CompositeGraphLayoutTest.assertTrue((n1.x != X ? 1 : 0) != 0);
    }
}

