/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.ReferenceNewElementSpec;
import org.eclipse.gmf.mappings.provider.GMFMapItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandcodedGMFMapItemProvidersTest
extends TestCase {
    Resource resource;

    public HandcodedGMFMapItemProvidersTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ResourceSetImpl rs = new ResourceSetImpl();
        URI uri = URI.createURI((String)"uri://myResource");
        this.resource = rs.getResource(uri, false);
        if (this.resource == null) {
            this.resource = rs.createResource(uri);
        }
        HandcodedGMFMapItemProvidersTest.assertNotNull((String)"Resource must have been created", (Object)this.resource);
        rs.getResources().add((Object)EcorePackage.eINSTANCE.eResource());
    }

    public void testReferenceNewElementInitializer() throws Exception {
        EReference feature = GMFMapPackage.eINSTANCE.getFeatureInitializer_Feature();
        FeatureSeqInitializer fSeqInitializer = this.createRootInitializer(EcorePackage.eINSTANCE.getEClass());
        ReferenceNewElementSpec featureInitializer = GMFMapFactory.eINSTANCE.createReferenceNewElementSpec();
        fSeqInitializer.getInitializers().add((Object)featureInitializer);
        featureInitializer.setFeature((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_EStructuralFeatures());
        FeatureSeqInitializer newElementInitializer = GMFMapFactory.eINSTANCE.createFeatureSeqInitializer();
        featureInitializer.getNewElementInitializers().add((Object)newElementInitializer);
        Collection newEStructuralFeatureChoices = HandcodedGMFMapItemProvidersTest.getChoiceOfValues((EObject)newElementInitializer, (EStructuralFeature)GMFMapPackage.eINSTANCE.getFeatureSeqInitializer_ElementClass());
        this.assertConcreteSubClasses(EcorePackage.eINSTANCE.getEStructuralFeature(), newEStructuralFeatureChoices);
        HandcodedGMFMapItemProvidersTest.assertEquals((String)"Only EReference, EAttribute subclasses expected", Arrays.asList(EcorePackage.eINSTANCE.getEAttribute(), EcorePackage.eINSTANCE.getEReference()), (Object)newEStructuralFeatureChoices);
        FeatureValueSpec nestedFeatureValueSpec = GMFMapFactory.eINSTANCE.createFeatureValueSpec();
        newElementInitializer.getInitializers().add((Object)nestedFeatureValueSpec);
        newElementInitializer.setElementClass(EcorePackage.eINSTANCE.getEAttribute());
        this.assertInitFeatures(EcorePackage.eINSTANCE.getEAttribute(), HandcodedGMFMapItemProvidersTest.getChoiceOfValues((EObject)nestedFeatureValueSpec, (EStructuralFeature)feature));
        newElementInitializer.setElementClass(null);
        this.assertInitFeatures(EcorePackage.eINSTANCE.getEStructuralFeature(), HandcodedGMFMapItemProvidersTest.getChoiceOfValues((EObject)nestedFeatureValueSpec, (EStructuralFeature)feature));
    }

    public void testFeatureInitializer() throws Exception {
        EReference feature = GMFMapPackage.eINSTANCE.getFeatureInitializer_Feature();
        FeatureSeqInitializer fSeqInitializer = this.createRootInitializer(EcorePackage.eINSTANCE.getEClass());
        FeatureValueSpec featureInitializer = GMFMapFactory.eINSTANCE.createFeatureValueSpec();
        fSeqInitializer.getInitializers().add((Object)featureInitializer);
        HandcodedGMFMapItemProvidersTest.assertEquals(Collections.singleton(fSeqInitializer.getElementClass()), (Object)HandcodedGMFMapItemProvidersTest.getChoiceOfValues((EObject)fSeqInitializer, (EStructuralFeature)GMFMapPackage.eINSTANCE.getFeatureSeqInitializer_ElementClass()));
        this.assertInitFeatures(EcorePackage.eINSTANCE.getEClass(), HandcodedGMFMapItemProvidersTest.getChoiceOfValues((EObject)featureInitializer, (EStructuralFeature)feature));
        fSeqInitializer.getMappingEntry().setDomainMetaElement(null);
        HandcodedGMFMapItemProvidersTest.assertEqualsChoices("All ecore features expected for no domain element", HandcodedGMFMapItemProvidersTest.appendNullChoice(this.getAllFeatures()), HandcodedGMFMapItemProvidersTest.getChoiceOfValues((EObject)featureInitializer, (EStructuralFeature)feature));
    }

    void assertInitFeatures(EClass elementClass, Collection<EStructuralFeature> featureChoices) {
        HandcodedGMFMapItemProvidersTest.assertTrue((String)"multiple features expected", (featureChoices.size() > 0 ? 1 : 0) != 0);
        for (EStructuralFeature nextFeature : featureChoices) {
            HandcodedGMFMapItemProvidersTest.assertTrue((String)"Feature must be changeable", (boolean)nextFeature.isChangeable());
            HandcodedGMFMapItemProvidersTest.assertTrue((String)"Feature must come from the element EClas", (boolean)nextFeature.getEContainingClass().isSuperTypeOf(elementClass));
        }
    }

    void assertConcreteSubClasses(EClass superClass, Collection<EClass> eClassChoices) {
        HandcodedGMFMapItemProvidersTest.assertTrue((String)"multiple EClasses expected", (eClassChoices.size() > 0 ? 1 : 0) != 0);
        for (EClass nextClass : eClassChoices) {
            HandcodedGMFMapItemProvidersTest.assertTrue((String)"Choice EClass must be subClass", (boolean)superClass.isSuperTypeOf(nextClass));
            HandcodedGMFMapItemProvidersTest.assertTrue((String)"Concrete EClass expected", (!nextClass.isAbstract() && !nextClass.isInterface() ? 1 : 0) != 0);
        }
    }

    private FeatureSeqInitializer createRootInitializer(EClass domainElement) {
        NodeMapping mappingEntry = GMFMapFactory.eINSTANCE.createNodeMapping();
        this.resource.getContents().add((Object)mappingEntry);
        mappingEntry.setDomainMetaElement(domainElement);
        FeatureSeqInitializer fSeqInitializer = GMFMapFactory.eINSTANCE.createFeatureSeqInitializer();
        mappingEntry.setDomainInitializer((ElementInitializer)fSeqInitializer);
        return fSeqInitializer;
    }

    private static void assertEqualsChoices(String msg, Collection c1, Collection c2) {
        HandcodedGMFMapItemProvidersTest.assertEquals((String)msg, new HashSet(c1), new HashSet(c2));
    }

    private static List<EClass> getAllEClasses() {
        ArrayList<EClass> allClasses = new ArrayList<EClass>();
        for (EClassifier nextClassifier : EcorePackage.eINSTANCE.getEClassifiers()) {
            if (!(nextClassifier instanceof EClass)) continue;
            allClasses.add((EClass)nextClassifier);
        }
        return allClasses;
    }

    private List<EStructuralFeature> getAllFeatures() {
        ArrayList<EStructuralFeature> featList = new ArrayList<EStructuralFeature>();
        for (EClass eClass : HandcodedGMFMapItemProvidersTest.getAllEClasses()) {
            featList.addAll((Collection<EStructuralFeature>)eClass.getEStructuralFeatures());
        }
        return featList;
    }

    private static <T> Collection<T> appendNullChoice(Collection<T> choices) {
        HandcodedGMFMapItemProvidersTest.assertFalse((boolean)choices.contains(null));
        ArrayList<T> allWithNull = new ArrayList<T>(choices);
        allWithNull.add(null);
        return allWithNull;
    }

    private static Collection getChoiceOfValues(EObject object, EStructuralFeature featureToSet) {
        IItemPropertySource propertySource = (IItemPropertySource)new GMFMapItemProviderAdapterFactory().adapt((Notifier)object, IItemPropertySource.class);
        IItemPropertyDescriptor propertyDescriptor = null;
        for (IItemPropertyDescriptor nextDescriptor : propertySource.getPropertyDescriptors((Object)object)) {
            if (nextDescriptor.getFeature((Object)object) != featureToSet) continue;
            propertyDescriptor = nextDescriptor;
        }
        HandcodedGMFMapItemProvidersTest.assertNotNull((String)("Property descriptor for " + featureToSet + " must exist"), propertyDescriptor);
        return propertyDescriptor.getChoiceOfValues((Object)object);
    }
}

