/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.annotated;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.annotated.AbstractASetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphDefASetup
extends AbstractASetup
implements DiaDefSource {
    protected EPackage ePackage;
    protected Canvas canvas;
    protected FigureGallery fGallery;
    protected Map<EObject, DiagramElement> owners;

    public GraphDefASetup(EPackage ePackage) {
        this.ePackage = ePackage;
    }

    @Override
    protected Iterator<EObject> getAllDomainModelContents() {
        return this.ePackage.eAllContents();
    }

    protected void createCanvas() {
        this.owners = new HashMap<EObject, DiagramElement>();
        this.canvas = GMFGraphFactory.eINSTANCE.createCanvas();
        this.canvas.setName("Default");
        this.fGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        this.fGallery.setName("default");
        this.canvas.getFigures().add((Object)this.fGallery);
        this.processDomainModel();
    }

    @Override
    protected void processCanvas(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        this.canvas.setName(this.getName(element, name));
    }

    @Override
    protected void processNode(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        Node node = this.createNode(element, name, params);
        this.canvas.getNodes().add((Object)node);
        RealFigure figure = this.createNodeFigure(node, element, params);
        FigureDescriptor fd = DiaDefSetup.newDescriptor(figure);
        this.fGallery.getDescriptors().add((Object)fd);
        node.setFigure(fd);
        this.owners.put((EObject)element, (DiagramElement)node);
    }

    protected Node createNode(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        Node node = GMFGraphFactory.eINSTANCE.createNode();
        node.setName(this.getName(element, name));
        return node;
    }

    protected RealFigure createNodeFigure(Node node, EModelElement element, List<AbstractASetup.Parameter> params) {
        Rectangle figure = GMFGraphFactory.eINSTANCE.createRectangle();
        figure.setName(String.valueOf(node.getName()) + "Figure");
        return figure;
    }

    @Override
    protected void processCompartment(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        Compartment compartment = this.createCompartment(element, name, params);
        this.canvas.getCompartments().add((Object)compartment);
        RealFigure figure = this.createCompartmentFigure(compartment, element, params);
        FigureDescriptor fd = DiaDefSetup.newDescriptor(figure);
        this.fGallery.getDescriptors().add((Object)fd);
        compartment.setFigure(fd);
    }

    protected Compartment createCompartment(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        Compartment compartment = GMFGraphFactory.eINSTANCE.createCompartment();
        compartment.setName(this.getName(element, name));
        return compartment;
    }

    protected RealFigure createCompartmentFigure(Compartment compartment, EModelElement element, List<AbstractASetup.Parameter> params) {
        Rectangle figure = GMFGraphFactory.eINSTANCE.createRectangle();
        figure.setName(String.valueOf(compartment.getName()) + "Figure");
        return figure;
    }

    @Override
    protected void processLink(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        Connection connection = this.createLink(element, name, params);
        this.canvas.getConnections().add((Object)connection);
        RealFigure figure = this.createLinkFigure(connection, element, params);
        FigureDescriptor fd = DiaDefSetup.newDescriptor(figure);
        this.fGallery.getDescriptors().add((Object)fd);
        connection.setFigure(fd);
        this.owners.put((EObject)element, (DiagramElement)connection);
    }

    protected Connection createLink(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        Connection connection = GMFGraphFactory.eINSTANCE.createConnection();
        connection.setName(this.getName(element, name));
        return connection;
    }

    protected RealFigure createLinkFigure(Connection connection, EModelElement element, List<AbstractASetup.Parameter> params) {
        PolylineConnection figure = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        figure.setName(String.valueOf(connection.getName()) + "Figure");
        return figure;
    }

    @Override
    protected void processLabel(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        DiagramLabel label = this.createLabel(element, name, params);
        this.canvas.getLabels().add((Object)label);
        RealFigure figure = this.createLabelFigure(label, element, params);
        DiagramElement host = this.owners.get(element.eContainer());
        if (host != null) {
            ((RealFigure)host.getFigure().getActualFigure()).getChildren().add((Object)figure);
            ChildAccess ca = DiaDefSetup.newAccess(host.getFigure(), figure);
            label.setFigure(host.getFigure());
            label.setAccessor(ca);
        } else {
            FigureDescriptor fd = DiaDefSetup.newDescriptor(figure);
            this.fGallery.getDescriptors().add((Object)fd);
            label.setFigure(fd);
        }
    }

    protected DiagramLabel createLabel(EModelElement element, String name, List<AbstractASetup.Parameter> params) {
        DiagramLabel label = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        label.setName(this.getName(element, name));
        return label;
    }

    protected RealFigure createLabelFigure(DiagramLabel label, EModelElement element, List<AbstractASetup.Parameter> params) {
        Label figure = GMFGraphFactory.eINSTANCE.createLabel();
        figure.setName(String.valueOf(label.getName()) + "Figure");
        return figure;
    }

    @Override
    public Canvas getCanvasDef() {
        if (this.canvas == null) {
            this.createCanvas();
            this.saveModel((EObject)this.canvas, "gmfgraph");
            this.validate((EObject)this.canvas);
        }
        return this.canvas;
    }

    @Override
    public DiagramLabel getLabelDef() {
        return null;
    }

    @Override
    public Connection getLinkDef() {
        return null;
    }

    @Override
    public Node getNodeDef() {
        return null;
    }
}

