/*******************************************************************************
* Copyright (c) 2006 Eclipse.org
* 
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.gmf.internal.xpand.parser;

public interface XpandLexersym {
    public final static int
      Char_CtlCharNotWS = 101,
      Char_LF = 98,
      Char_CR = 99,
      Char_HT = 88,
      Char_FF = 89,
      Char_a = 15,
      Char_b = 12,
      Char_c = 16,
      Char_d = 17,
      Char_e = 18,
      Char_f = 13,
      Char_g = 31,
      Char_h = 32,
      Char_i = 33,
      Char_j = 34,
      Char_k = 35,
      Char_l = 36,
      Char_m = 37,
      Char_n = 19,
      Char_o = 38,
      Char_p = 39,
      Char_q = 40,
      Char_r = 20,
      Char_s = 41,
      Char_t = 21,
      Char_u = 22,
      Char_v = 42,
      Char_w = 43,
      Char_x = 44,
      Char_y = 45,
      Char_z = 46,
      Char__ = 47,
      Char_A = 23,
      Char_B = 24,
      Char_C = 25,
      Char_D = 14,
      Char_E = 1,
      Char_F = 26,
      Char_G = 48,
      Char_H = 49,
      Char_I = 50,
      Char_J = 51,
      Char_K = 52,
      Char_L = 53,
      Char_M = 27,
      Char_N = 28,
      Char_O = 54,
      Char_P = 55,
      Char_Q = 56,
      Char_R = 29,
      Char_S = 57,
      Char_T = 58,
      Char_U = 59,
      Char_V = 60,
      Char_W = 61,
      Char_X = 62,
      Char_Y = 63,
      Char_Z = 64,
      Char_0 = 2,
      Char_1 = 3,
      Char_2 = 4,
      Char_3 = 5,
      Char_4 = 6,
      Char_5 = 7,
      Char_6 = 8,
      Char_7 = 9,
      Char_8 = 10,
      Char_9 = 11,
      Char_Space = 65,
      Char_DoubleQuote = 73,
      Char_SingleQuote = 74,
      Char_Percent = 90,
      Char_VerticalBar = 66,
      Char_Exclamation = 75,
      Char_AtSign = 91,
      Char_BackQuote = 92,
      Char_Acute = 105,
      Char_Tilde = 93,
      Char_Sharp = 94,
      Char_DollarSign = 95,
      Char_Ampersand = 67,
      Char_Caret = 96,
      Char_Colon = 68,
      Char_SemiColon = 97,
      Char_BackSlash = 76,
      Char_LeftBrace = 77,
      Char_RightBrace = 78,
      Char_LeftBracket = 79,
      Char_RightBracket = 80,
      Char_QuestionMark = 81,
      Char_Comma = 82,
      Char_Dot = 69,
      Char_LessThan = 83,
      Char_GreaterThan = 70,
      Char_Plus = 84,
      Char_Minus = 85,
      Char_Slash = 71,
      Char_Star = 72,
      Char_LeftParen = 86,
      Char_RightParen = 87,
      Char_Equal = 30,
      Char_AfterASCII = 102,
      Char_LG = 103,
      Char_RG = 100,
      Char_EOF = 104;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "E",
                 "0",
                 "1",
                 "2",
                 "3",
                 "4",
                 "5",
                 "6",
                 "7",
                 "8",
                 "9",
                 "b",
                 "f",
                 "D",
                 "a",
                 "c",
                 "d",
                 "e",
                 "n",
                 "r",
                 "t",
                 "u",
                 "A",
                 "B",
                 "C",
                 "F",
                 "M",
                 "N",
                 "R",
                 "Equal",
                 "g",
                 "h",
                 "i",
                 "j",
                 "k",
                 "l",
                 "m",
                 "o",
                 "p",
                 "q",
                 "s",
                 "v",
                 "w",
                 "x",
                 "y",
                 "z",
                 "_",
                 "G",
                 "H",
                 "I",
                 "J",
                 "K",
                 "L",
                 "O",
                 "P",
                 "Q",
                 "S",
                 "T",
                 "U",
                 "V",
                 "W",
                 "X",
                 "Y",
                 "Z",
                 "Space",
                 "VerticalBar",
                 "Ampersand",
                 "Colon",
                 "Dot",
                 "GreaterThan",
                 "Slash",
                 "Star",
                 "DoubleQuote",
                 "SingleQuote",
                 "Exclamation",
                 "BackSlash",
                 "LeftBrace",
                 "RightBrace",
                 "LeftBracket",
                 "RightBracket",
                 "QuestionMark",
                 "Comma",
                 "LessThan",
                 "Plus",
                 "Minus",
                 "LeftParen",
                 "RightParen",
                 "HT",
                 "FF",
                 "Percent",
                 "AtSign",
                 "BackQuote",
                 "Tilde",
                 "Sharp",
                 "DollarSign",
                 "Caret",
                 "SemiColon",
                 "LF",
                 "CR",
                 "RG",
                 "CtlCharNotWS",
                 "AfterASCII",
                 "LG",
                 "EOF",
                 "Acute"
             };

    public final static boolean isValidForParser = true;
}
