/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ErrorLocationInfo[] errors;
    private final String qualifiedResourceName;

    private static String getMessage(String qualifiedName, ErrorLocationInfo[] errors) {
        assert (errors != null && errors.length > 0);
        StringBuilder result = new StringBuilder("Following parser errors was reported while parsing " + qualifiedName + " resource:\n");
        ErrorLocationInfo[] errorLocationInfoArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorLocationInfo errorLocationInfo = errorLocationInfoArray[n2];
            result.append("\t");
            result.append(errorLocationInfo.toString());
            result.append("\n");
            ++n2;
        }
        return result.toString();
    }

    public ParserException(String qualifiedName, Collection<? extends ErrorLocationInfo> errors) {
        this(qualifiedName, errors.toArray(new ErrorLocationInfo[errors.size()]));
    }

    public ParserException(String qualifiedName, ErrorLocationInfo ... errors) {
        super(ParserException.getMessage(qualifiedName, errors));
        assert (errors != null && errors.length > 0);
        this.errors = errors;
        this.qualifiedResourceName = qualifiedName;
    }

    public ErrorLocationInfo[] getParsingErrors() {
        return this.errors;
    }

    public String getResourceName() {
        return this.qualifiedResourceName;
    }

    public static class ErrorLocationInfo {
        public final int startLine;
        public final int startColumn;
        public final int endLine;
        public final int endColumn;
        public final String message;

        public ErrorLocationInfo(String message) {
            this(message, -1, -1, -1, -1);
        }

        public ErrorLocationInfo(String message, int startLine, int startColumn, int endLine, int endColumn) {
            this.message = message;
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public String toString() {
            return String.valueOf(this.startLine) + ":" + this.startColumn + "-" + this.endLine + ":" + this.endColumn + " - " + this.message;
        }
    }
}

