/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lpg.lpgjavaruntime.LexParser;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.LpgLexStream;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.RuleAction;
import lpg.lpgjavaruntime.TokenStream;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.parser.XpandKWLexer;
import org.eclipse.gmf.internal.xpand.parser.XpandLexerprs;
import org.eclipse.gmf.internal.xpand.parser.XpandLexersym;
import org.eclipse.gmf.internal.xpand.parser.XpandParsersym;
import org.eclipse.gmf.internal.xpand.util.ParserException;

public class XpandLexer
extends LpgLexStream
implements XpandParsersym,
XpandLexersym,
RuleAction {
    private static ParseTable prs = new XpandLexerprs();
    private PrsStream prsStream;
    private final LexParser lexParser = new LexParser((TokenStream)this, prs, (RuleAction)this);
    private XpandKWLexer kwLexer;
    private final int[] tokenKind = new int[]{102, 102, 102, 102, 102, 102, 102, 102, 102, 76, 91, 102, 99, 92, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 71, 78, 93, 95, 72, 94, 96, 98, 89, 90, 70, 69, 88, 67, 20, 75, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 74, 82, 68, 12, 21, 87, 79, 46, 47, 48, 16, 11, 49, 50, 51, 52, 53, 54, 55, 17, 18, 56, 57, 58, 19, 59, 60, 61, 62, 63, 64, 65, 66, 85, 97, 86, 73, 45, 80, 22, 23, 24, 25, 13, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 14, 36, 15, 37, 38, 39, 40, 41, 42, 43, 44, 83, 77, 84, 81, 103, 106};
    private final List<ParserException.ErrorLocationInfo> errors = new LinkedList<ParserException.ErrorLocationInfo>();

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getFirstToken();
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    public XpandLexer(char[] input_chars, String filename, int tab) {
        super(input_chars, filename, tab);
    }

    public XpandLexer(char[] input_chars, String filename) {
        this(input_chars, filename, 4);
    }

    public String[] orderedExportedSymbols() {
        return XpandParsersym.orderedTerminalSymbols;
    }

    public LexStream getLexStream() {
        return this;
    }

    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    public void lexer(PrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    public void lexer(Monitor monitor, PrsStream prsStream) {
        if (this.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.prsStream = prsStream;
        this.resetErrors();
        prsStream.makeToken(0, 0, 0);
        this.lexParser.parseCharacters(monitor);
        int i = this.getStreamIndex();
        prsStream.makeToken(i, i, 108);
        prsStream.setStreamLength(prsStream.getSize());
    }

    public void initialize(char[] content, String filename) {
        super.initialize(content, filename);
        if (this.kwLexer == null) {
            this.kwLexer = new XpandKWLexer(this.getInputChars(), 3);
        } else {
            this.kwLexer.setInputChars(this.getInputChars());
        }
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.makeToken(startOffset, endOffset, kind);
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        super.getPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.makeToken(startOffset, endOffset, kwKind);
    }

    public final int getKind(int i) {
        char c;
        char c2 = c = i >= this.getStreamLength() ? (char)'\uffff' : (char)this.getCharValue(i);
        return c < '\u0080' ? this.tokenKind[c] : (c == '\uffff' ? 106 : XpandLexer.getNonAsciiKind(c));
    }

    private static final int getNonAsciiKind(char c) {
        if (c == '\u00ab') {
            return 104;
        }
        if (c == '\u00bb') {
            return 101;
        }
        if (c == '\u00b4') {
            return 105;
        }
        return 103;
    }

    public ParserException.ErrorLocationInfo[] getErrors() {
        return this.errors.toArray(new ParserException.ErrorLocationInfo[this.errors.size()]);
    }

    private void resetErrors() {
        this.errors.clear();
    }

    public void reportError(int i, String code) {
        Activator.logWarn("Unexpected #reportError(int,String)");
        this.reportError(i, i);
    }

    public void reportError(int leftToken, int rightToken) {
        int errorCode = rightToken >= this.getStreamLength() ? 10 : (leftToken == rightToken ? 0 : 11);
        int endToken = leftToken == rightToken ? rightToken : rightToken - 1;
        this.reportError(errorCode, null, leftToken, endToken, this.getName(leftToken));
    }

    public void reportError(int errorCode, String locationInfo, String tokenText) {
        try {
            Matcher m = Pattern.compile("(?:[^:]+::)*[^:]+:(\\d+):(\\d+):(\\d+):(\\d+):.*").matcher(locationInfo);
            boolean t = m.matches();
            assert (t);
            int leftTokenLine = Integer.parseInt(m.group(1));
            int leftTokenColumn = Integer.parseInt(m.group(2));
            int rightTokenLine = Integer.parseInt(m.group(3));
            int rightTokenColumn = Integer.parseInt(m.group(4));
            String msg = String.valueOf(tokenText) + errorMsgText[errorCode];
            this.errors.add(new ParserException.ErrorLocationInfo(msg, leftTokenLine, leftTokenColumn, rightTokenLine, rightTokenColumn));
        }
        catch (Throwable throwable) {
            this.errors.add(new ParserException.ErrorLocationInfo(String.valueOf(tokenText) + errorMsgText[errorCode]));
        }
    }

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        int leftTokenLine = this.getLine(leftToken);
        int leftTokenColumn = this.getColumn(leftToken);
        int rightTokenLine = this.getEndLine(rightToken);
        int rightTokenColumn = this.getEndColumn(rightToken);
        String msg = String.valueOf(tokenText) + errorMsgText[errorCode] + (locationInfo != null && locationInfo.length() > 0 ? String.valueOf('(') + locationInfo + ')' : "");
        int startOffset = leftToken;
        int endOffset = rightToken;
        this.errors.add(new ParserException.ErrorLocationInfo(msg, leftTokenLine, leftTokenColumn, rightTokenLine, rightTokenColumn, startOffset, endOffset));
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.checkForKeyWord();
                break;
            }
            case 2: {
                this.makeToken(27);
                break;
            }
            case 3: {
                this.makeToken(27);
                break;
            }
            case 4: {
                this.makeToken(27);
                break;
            }
            case 5: {
                this.makeToken(27);
                break;
            }
            case 6: {
                this.makeToken(52);
                break;
            }
            case 7: {
                this.makeToken(53);
                break;
            }
            case 8: {
                this.makeToken(64);
                break;
            }
            case 9: {
                this.makeToken(86);
                break;
            }
            case 10: {
                this.skipToken();
                break;
            }
            case 11: {
                this.skipToken();
                break;
            }
            case 12: {
                this.skipToken();
                break;
            }
            case 13: {
                this.makeToken(32);
                break;
            }
            case 14: {
                this.makeToken(15);
                break;
            }
            case 15: {
                this.makeToken(4);
                break;
            }
            case 16: {
                this.makeToken(26);
                break;
            }
            case 17: {
                this.makeToken(1);
                break;
            }
            case 18: {
                this.makeToken(2);
                break;
            }
            case 19: {
                this.makeToken(16);
                break;
            }
            case 20: {
                this.makeToken(17);
                break;
            }
            case 21: {
                this.makeToken(5);
                break;
            }
            case 22: {
                this.makeToken(18);
                break;
            }
            case 23: {
                this.makeToken(19);
                break;
            }
            case 24: {
                this.makeToken(20);
                break;
            }
            case 25: {
                this.makeToken(76);
                break;
            }
            case 26: {
                this.makeToken(81);
                break;
            }
            case 27: {
                this.makeToken(74);
                break;
            }
            case 28: {
                this.makeToken(78);
                break;
            }
            case 29: {
                this.makeToken(90);
                break;
            }
            case 30: {
                this.makeToken(73);
                break;
            }
            case 31: {
                this.makeToken(71);
                break;
            }
            case 32: {
                this.makeToken(79);
                break;
            }
            case 33: {
                this.makeToken(75);
                break;
            }
            case 34: {
                this.makeToken(85);
                break;
            }
            case 35: {
                this.makeToken(91);
                break;
            }
            case 36: {
                this.makeToken(92);
                break;
            }
            case 37: {
                this.makeToken(82);
                break;
            }
            case 38: {
                this.makeToken(93);
                break;
            }
            case 39: {
                this.makeToken(94);
                break;
            }
            case 40: {
                this.makeToken(95);
                break;
            }
            case 305: {
                this.makeToken(96);
                break;
            }
            case 306: {
                this.makeToken(133);
                break;
            }
            case 307: {
                this.makeToken(134);
                break;
            }
            case 308: {
                this.makeToken(83);
                break;
            }
            case 309: {
                this.makeToken(80);
                break;
            }
            case 310: {
                this.makeToken(225);
                break;
            }
            case 311: {
                this.makeToken(226);
                break;
            }
            case 312: {
                this.makeToken(227);
                break;
            }
            case 313: {
                this.makeToken(228);
                break;
            }
            case 314: {
                this.makeToken(158);
                break;
            }
            case 322: {
                this.makeToken(27);
                break;
            }
            case 325: {
                this.makeToken(126);
                break;
            }
            case 326: {
                this.makeToken(72);
                break;
            }
            case 336: {
                this.skipToken();
                break;
            }
        }
    }
}

