/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SelectStackedElementsAction
extends Action
implements IMenuCreator,
MenuListener,
IObjectActionDelegate {
    public static final String EMPTY_STRING = "";
    private Menu myMenu;
    private AbstractFigureEditPart mySelectedElement;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        action.setMenuCreator(this.getMenuCreator());
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public Menu getMenu(Control parent) {
        return this.createMenu((Widget)parent);
    }

    public Menu getMenu(Menu parent) {
        return this.createMenu((Widget)parent);
    }

    protected Menu createMenu(Widget parent) {
        if (parent == null) {
            return null;
        }
        if (this.myMenu != null) {
            this.myMenu.dispose();
        }
        this.myMenu = SelectStackedElementsAction.createMenuFromMenuOrControlParent(parent);
        this.myMenu.addMenuListener((MenuListener)this);
        return this.myMenu;
    }

    public void menuShown(MenuEvent e) {
        this.clearMenu(this.myMenu);
        SelectStackedElementsAction.fillMenu(this.myMenu, (EditPart)this.mySelectedElement);
    }

    public void menuHidden(MenuEvent e) {
    }

    public void dispose() {
        if (this.myMenu != null) {
            this.myMenu.dispose();
        }
        this.myMenu = null;
    }

    private void clearMenu(Menu menu) {
        MenuItem[] actions = menu.getItems();
        int i = 0;
        while (i < actions.length) {
            actions[i].dispose();
            ++i;
        }
    }

    private static Menu createMenuFromMenuOrControlParent(Widget parent) {
        Menu result = null;
        if (parent instanceof Menu) {
            result = new Menu((Menu)parent);
        } else if (parent instanceof Control) {
            result = new Menu((Control)parent);
        }
        return result;
    }

    private static void fillMenu(Menu menu, EditPart selectedElement) {
        if (selectedElement == null) {
            return;
        }
        int numChildren = selectedElement.getChildren().size();
        IAction[] selectChildActions = new IAction[numChildren];
        ArrayList<ExpandChildrenAction> expandChildrenActions = new ArrayList<ExpandChildrenAction>(numChildren);
        int i = 0;
        while (i < numChildren) {
            EditPart next = (EditPart)selectedElement.getChildren().get(i);
            String className = next.getClass().getName();
            String preciseName = String.valueOf(i);
            if (next instanceof AbstractFigureEditPart) {
                View model = (View)((AbstractFigureEditPart)next).getModel();
                RealFigure modelElement = (RealFigure)model.getElement();
                className = modelElement.eClass().getName();
                String elementName = modelElement.getName();
                if (elementName != null && elementName.length() != 0) {
                    preciseName = elementName;
                }
            }
            String selectChildCommandName = MessageFormat.format("{0}:{1}", className, preciseName);
            selectChildActions[i] = new SelectChildAction(next, selectChildCommandName);
            if (next.getChildren().size() > 0) {
                String expandChildrenCommandName = numChildren > 1 ? MessageFormat.format("Select Children of {0}", selectChildCommandName) : "Select Children";
                expandChildrenActions.add(new ExpandChildrenAction(next, expandChildrenCommandName));
            }
            ++i;
        }
        i = 0;
        while (i < selectChildActions.length) {
            ActionContributionItem item = new ActionContributionItem(selectChildActions[i]);
            item.fill(menu, -1);
            ++i;
        }
        int numExpandableCommands = expandChildrenActions.size();
        if (numExpandableCommands > 0) {
            new MenuItem(menu, 2, selectChildActions.length);
            int i2 = 0;
            while (i2 < numExpandableCommands) {
                IAction next = (IAction)expandChildrenActions.get(i2);
                ActionContributionItem item = new ActionContributionItem(next);
                item.fill(menu, selectChildActions.length + i2 + 1);
                ++i2;
            }
        }
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.mySelectedElement = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof AbstractFigureEditPart) {
            this.mySelectedElement = (AbstractFigureEditPart)((Object)structuredSelection.getFirstElement());
        }
        action.setEnabled(this.isEnabled());
    }

    public boolean isEnabled() {
        return this.mySelectedElement != null && this.mySelectedElement.getChildren().size() > 0;
    }

    private static class ExpandChildrenAction
    extends Action
    implements IMenuCreator,
    Comparable {
        private final EditPart myTarget;
        private final String myName;
        private Menu myMenu;

        public ExpandChildrenAction(EditPart target, String name) {
            super(name, 4);
            this.myName = name;
            this.myTarget = target;
        }

        public IMenuCreator getMenuCreator() {
            return this;
        }

        public EditPart getTargetPart() {
            return this.myTarget;
        }

        public String getName() {
            return this.myName;
        }

        public void run() {
        }

        public int compareTo(Object o) {
            if (!(o instanceof SelectChildAction)) {
                return -1;
            }
            String otherName = ((SelectChildAction)o).getName();
            return Collator.getInstance().compare(this.getName(), otherName);
        }

        public void dispose() {
            if (this.myMenu != null) {
                this.myMenu.dispose();
            }
            this.myMenu = null;
        }

        public Menu getMenu(Control parent) {
            return this.createMenu((Widget)parent);
        }

        public Menu getMenu(Menu parent) {
            return this.createMenu((Widget)parent);
        }

        private Menu createMenu(Widget parent) {
            if (this.myMenu == null) {
                if (parent == null) {
                    return null;
                }
                this.myMenu = SelectStackedElementsAction.createMenuFromMenuOrControlParent(parent);
                SelectStackedElementsAction.fillMenu(this.myMenu, this.myTarget);
            }
            return this.myMenu;
        }
    }

    private static class SelectChildAction
    extends Action
    implements Comparable {
        private final EditPart myTarget;
        private final String myName;

        public SelectChildAction(EditPart target, String name) {
            super(name, 1);
            this.myName = name;
            this.myTarget = target;
        }

        public EditPart getTargetPart() {
            return this.myTarget;
        }

        public String getName() {
            return this.myName;
        }

        public void run() {
            this.myTarget.getViewer().select(this.myTarget);
        }

        public int compareTo(Object o) {
            if (!(o instanceof SelectChildAction)) {
                return -1;
            }
            String otherName = ((SelectChildAction)o).getName();
            return Collator.getInstance().compare(this.getName(), otherName);
        }
    }
}

