/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;

public class FixedOffsetLocator
implements Locator {
    protected IFigure reference;
    protected Point offset;
    protected int alignment;

    public FixedOffsetLocator(IFigure reference, Point offset, int alignment) {
        this.reference = reference;
        this.offset = offset;
        this.alignment = alignment;
    }

    public void relocate(IFigure target) {
        Rectangle bounds = this.reference instanceof HandleBounds ? ((HandleBounds)this.reference).getHandleBounds() : this.reference.getBounds();
        bounds = bounds.getCopy();
        this.reference.translateToAbsolute((Translatable)bounds);
        target.translateToRelative((Translatable)bounds);
        this.setLocation(bounds, target);
        target.setSize(target.getPreferredSize());
    }

    protected void setLocation(Rectangle refBounds, IFigure target) {
        Point p;
        switch (this.alignment) {
            case 1: {
                p = refBounds.getLeft();
                break;
            }
            case 4: {
                p = refBounds.getRight();
                break;
            }
            default: {
                p = refBounds.getCenter();
            }
        }
        target.setLocation(p.getTranslated(this.offset));
    }
}

