/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class CreationTool
extends org.eclipse.gef.tools.CreationTool {
    protected boolean antiScroll = false;
    private static final Point UNDEFINED_POINT = LayoutHelper.UNDEFINED.getLocation();
    private IElementType elementType = null;
    private static Cursor CURSOR_SHAPE = new Cursor((Device)Display.getDefault(), DiagramUIPluginImages.DESC_SHAPECURSOR_SOURCE.getImageData(), DiagramUIPluginImages.DESC_SHAPECURSOR_MASK.getImageData(), 7, 7);
    private static Cursor CURSOR_SHAPE_NOT = new Cursor((Device)Display.getDefault(), DiagramUIPluginImages.DESC_NOSHAPECURSOR_SOURCE.getImageData(), DiagramUIPluginImages.DESC_NOSHAPECURSOR_MASK.getImageData(), 7, 7);

    public CreationTool(IElementType elementType) {
        this.setElementType(elementType);
        this.setDefaultCursor(CURSOR_SHAPE);
        this.setDisabledCursor(CURSOR_SHAPE_NOT);
    }

    protected CreationTool() {
    }

    protected PreferencesHint getPreferencesHint() {
        RootEditPart rootEP;
        EditPartViewer viewer = this.getCurrentViewer();
        if (viewer != null && (rootEP = viewer.getRootEditPart()) instanceof IDiagramPreferenceSupport) {
            return ((IDiagramPreferenceSupport)rootEP).getPreferencesHint();
        }
        return PreferencesHint.USE_DEFAULTS;
    }

    protected Request createTargetRequest() {
        return CreateViewRequestFactory.getCreateShapeRequest(this.getElementType(), this.getPreferencesHint());
    }

    public void deactivate() {
        super.deactivate();
        this.setTargetRequest(null);
    }

    protected void performCreation(int button) {
        this.antiScroll = true;
        EditPartViewer viewer = this.getCurrentViewer();
        Command c = this.getCurrentCommand();
        this.executeCurrentCommand();
        this.selectAddedObject(viewer, DiagramCommandStack.getReturnValues(c));
        this.antiScroll = false;
    }

    protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
        final ArrayList editparts = new ArrayList();
        for (Object object : objects) {
            Object editPart;
            if (!(object instanceof IAdaptable) || (editPart = viewer.getEditPartRegistry().get(((IAdaptable)object).getAdapter(View.class))) == null) continue;
            editparts.add(editPart);
        }
        if (!editparts.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    EditPart editPart = (EditPart)editparts.get(0);
                    if (editPart.isActive()) {
                        editPart.performRequest(new Request((Object)"direct edit"));
                        CreationTool.this.revealEditPart((EditPart)editparts.get(0));
                    }
                }
            });
        }
    }

    protected boolean handleDoubleClick(int button) {
        this.createShapeAt(UNDEFINED_POINT);
        this.setState(0x40000000);
        this.handleFinished();
        return true;
    }

    protected void createShapeAt(Point point) {
        this.setTargetEditPart(this.getCurrentViewer().getRootEditPart().getContents());
        this.getCreateRequest().setLocation(point);
        this.setCurrentCommand(this.getCommand());
        this.performCreation(0);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (e.keyCode == 13) {
            this.setEditDomain(this.getCurrentViewer().getEditDomain());
            this.createShapeAt(UNDEFINED_POINT);
            return true;
        }
        return false;
    }

    protected void setTargetEditPart(EditPart editpart) {
        if (editpart != this.getTargetEditPart()) {
            this.setTargetRequest(null);
        }
        super.setTargetEditPart(editpart);
    }

    public IElementType getElementType() {
        return this.elementType;
    }

    private void setElementType(IElementType elementType) {
        this.elementType = elementType;
    }

    protected void handleFinished() {
        if (!this.getCurrentInput().isControlKeyDown()) {
            super.handleFinished();
        } else {
            this.reactivate();
        }
    }

    protected boolean handleMove() {
        if (!this.antiScroll) {
            return super.handleMove();
        }
        return false;
    }

    protected void doAutoexpose() {
        if (!this.antiScroll) {
            super.doAutoexpose();
        }
    }

    protected Command getCommand() {
        if (!this.antiScroll) {
            return super.getCommand();
        }
        return null;
    }

    protected void revealEditPart(EditPart editPart) {
        if (editPart != null && editPart.getViewer() != null) {
            editPart.getViewer().reveal(editPart);
        }
    }

    public final Request createCreateRequest() {
        return this.createTargetRequest();
    }

    public final void selectNewShapes(EditPartViewer viewer, Collection objects) {
        this.selectAddedObject(viewer, objects);
    }
}

