/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.handles;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.internal.runtime.lite.PluginImages;
import org.eclipse.gmf.runtime.lite.handles.CompartmentCollapseTracker;
import org.eclipse.gmf.runtime.lite.handles.CompartmentNameHandle;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;

public class CompartmentCollapseHandle
extends CompartmentNameHandle {
    private ResourceSetListener myResourceSetListener;
    private TransactionalEditingDomain myDomain;

    public CompartmentCollapseHandle(GraphicalEditPart owner, String title) {
        super(owner, title);
        View ownerView = this.getOwnerView();
        NotificationFilter filter = NotificationFilter.createNotifierFilter((Object)ownerView).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getView_Styles()));
        NotificationFilter childrenFilter = NotificationFilter.createNotifierFilter((Object)ownerView).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getView_PersistedChildren()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getView_TransientChildren())));
        filter = filter.or(childrenFilter);
        DrawerStyle drawerStyle = (DrawerStyle)ownerView.getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        if (drawerStyle != null) {
            NotificationFilter styleFilter = NotificationFilter.createNotifierFilter((Object)drawerStyle).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed()));
            filter = filter.or(styleFilter);
        }
        this.myResourceSetListener = new ResourceSetListenerImpl(filter){

            public boolean isAggregatePrecommitListener() {
                return true;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                CompartmentCollapseHandle.this.updateIcon();
            }
        };
        this.updateIcon();
    }

    private void updateIcon() {
        this.getLabel().setIcon(this.getCollapseIcon());
    }

    private Image getCollapseIcon() {
        if (this.isEmptyContents()) {
            return null;
        }
        if (this.isCollapsed()) {
            return PluginImages.get("icons/expand.gif");
        }
        return PluginImages.get("icons/collapse.gif");
    }

    private boolean isCollapsed() {
        View ownerView = this.getOwnerView();
        if (ownerView == null) {
            return false;
        }
        DrawerStyle drawerStyle = (DrawerStyle)ownerView.getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        return drawerStyle != null && drawerStyle.isCollapsed();
    }

    private View getOwnerView() {
        return this.getOwner().getModel() instanceof View ? (View)this.getOwner().getModel() : null;
    }

    public void addNotify() {
        super.addNotify();
        View ownerView = this.getOwnerView();
        this.myDomain = TransactionUtil.getEditingDomain((EObject)ownerView);
        if (this.myDomain != null) {
            this.myDomain.addResourceSetListener(this.myResourceSetListener);
        }
    }

    public void removeNotify() {
        if (this.myDomain != null) {
            this.myDomain.removeResourceSetListener(this.myResourceSetListener);
            this.myDomain = null;
        }
        super.removeNotify();
    }

    public DragTracker getDragTracker() {
        if (this.getOwnerView() != null && !this.isEmptyContents()) {
            return new CompartmentCollapseTracker(this.getOwner());
        }
        return null;
    }

    protected boolean isEmptyContents() {
        if (this.isCollapsed()) {
            return this.getOwnerView() == null || this.getOwnerView().getVisibleChildren().isEmpty();
        }
        return this.getOwner().getChildren().isEmpty();
    }
}

