/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.EMFTranscoder;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.WMFTranscoder;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageType;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;

public class SVGImageType
implements RenderedImageType {
    public RenderedImage autoDetect(byte[] buffer, RenderedImageKey key) {
        SVGImage image = null;
        if (SVGImageType.isSVG(buffer)) {
            image = new SVGImage(buffer, key);
        } else {
            try {
                WMFTranscoder imageTransformer = new WMFTranscoder();
                ByteArrayInputStream input = new ByteArrayInputStream(buffer);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                imageTransformer.transcode(input, output);
                image = new SVGImage(output.toByteArray(), key);
            }
            catch (Exception exception) {
                try {
                    EMFTranscoder imageTransformer = new EMFTranscoder();
                    ByteArrayInputStream input = new ByteArrayInputStream(buffer);
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    imageTransformer.transcode(input, output);
                    image = new SVGImage(output.toByteArray(), key);
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }
        return image;
    }

    private static boolean isSVG(byte[] buffer) {
        ByteArrayInputStream bIS = new ByteArrayInputStream(buffer);
        String parserName = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory svgFactory = new SAXSVGDocumentFactory(parserName);
        try {
            svgFactory.createDocument(null, (InputStream)bIS);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

