/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.internal.resources;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCoreDebugOptions;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCorePlugin;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.resources.IPathmapManager;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class PathmapManager
extends AdapterImpl
implements IPathmapManager {
    private static final String NAME = "name";
    private static final String PLUGIN = "plugin";
    private static final String PATH = "path";
    private static final String NODE_QUALIFIER = EMFCorePlugin.getDefault().getBundle().getSymbolicName();
    private static final String PREFERENCE_KEY = "referenced.path.variables";
    private static final Map PATH_MAP = Collections.synchronizedMap(PathmapManager.configure());
    private static final Map instances = Collections.synchronizedMap(new WeakHashMap());
    private static Set referencedPathVariablesList;
    private static IEclipsePreferences preferenceStore;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        preferenceStore = null;
        IPathVariableManager pathManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IEclipsePreferences preferences = PathmapManager.getPreferenceStore();
        String referencedPathVariables = preferences.get(PREFERENCE_KEY, "");
        StringTokenizer tokenizer = new StringTokenizer(referencedPathVariables, " ");
        referencedPathVariablesList = new HashSet(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String pathVariable = tokenizer.nextToken();
            PathmapManager.addPathVariableReference(pathVariable);
        }
        PathmapManager.updatePreferenceStore();
        pathManager.addChangeListener(new IPathVariableChangeListener(){

            public void pathVariableChanged(IPathVariableChangeEvent event) {
                switch (event.getType()) {
                    case 3: {
                        PathmapManager.removePathVariableReference(event.getVariableName());
                        PathmapManager.updatePreferenceStore();
                        break;
                    }
                    case 1: {
                        if (!referencedPathVariablesList.contains(event.getVariableName())) break;
                        if (!PathmapManager.isDirectory(event.getValue())) {
                            PathmapManager.removePathVariableReference(event.getVariableName());
                        } else {
                            PathmapManager.setPathVariable(event.getVariableName(), URI.createFileURI((String)event.getValue().toString()).toString());
                        }
                        PathmapManager.updatePreferenceStore();
                    }
                }
            }
        });
    }

    private static IEclipsePreferences getPreferenceStore() {
        if (preferenceStore == null) {
            InstanceScope ctx = new InstanceScope();
            preferenceStore = ctx.getNode(NODE_QUALIFIER);
        }
        return preferenceStore;
    }

    public static void addPathVariableReference(String pathVariable) {
        if (PathmapManager.getAllPathVariables().contains(pathVariable)) {
            return;
        }
        if (!PathmapManager.isCompatiblePathVariable(pathVariable)) {
            return;
        }
        IPathVariableManager pathManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath value = pathManager.getValue(pathVariable);
        if (value != null) {
            referencedPathVariablesList.add(pathVariable);
            PathmapManager.setPathVariable(pathVariable, URI.createFileURI((String)value.toString()).toString());
        }
    }

    public static void updatePreferenceStore() {
        StringBuffer referencedPathVariables = new StringBuffer();
        Iterator i = referencedPathVariablesList.iterator();
        while (i.hasNext()) {
            referencedPathVariables.append((String)i.next());
            referencedPathVariables.append(' ');
        }
        PathmapManager.getPreferenceStore().put(PREFERENCE_KEY, referencedPathVariables.toString());
        try {
            PathmapManager.getPreferenceStore().flush();
        }
        catch (BackingStoreException e) {
            EMFCorePlugin.getDefault().getLog().log((IStatus)new Status(4, EMFCorePlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
        }
    }

    public static void removePathVariableReference(String pathVariable) {
        if (referencedPathVariablesList.contains(pathVariable)) {
            referencedPathVariablesList.remove(pathVariable);
            PathmapManager.unsetPathVariable(pathVariable);
        }
    }

    public static Set getPathVariableReferences() {
        return Collections.unmodifiableSet(referencedPathVariablesList);
    }

    public static Set getAllPathVariables() {
        return Collections.unmodifiableSet(PATH_MAP.keySet());
    }

    public static boolean isRegisteredPathVariable(String variable) {
        return PATH_MAP.containsKey(variable) && !referencedPathVariablesList.contains(variable);
    }

    public static String getRegisteredValue(String variable) {
        return (String)PATH_MAP.get(variable);
    }

    public static boolean isCompatiblePathVariable(String variable) {
        if (referencedPathVariablesList.contains(variable)) {
            return true;
        }
        IPathVariableManager pathManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath value = pathManager.getValue(variable);
        if (value == null) {
            return false;
        }
        return PathmapManager.isDirectory(value);
    }

    private static boolean isDirectory(IPath value) {
        File f = new File(value.toString());
        return f.isDirectory();
    }

    public PathmapManager() {
        instances.put(this, Boolean.TRUE);
    }

    private static Set allInstances() {
        return instances.keySet();
    }

    public static PathmapManager getExistingPathmapManager(ResourceSet rset) {
        PathmapManager result = null;
        EList adapters = rset.eAdapters();
        int i = 0;
        int size = adapters.size();
        while (result == null && i < size) {
            Object next = adapters.get(i);
            if (next instanceof PathmapManager) {
                result = (PathmapManager)next;
            }
            ++i;
        }
        return result;
    }

    public static void setPathVariable(String var, String val) {
        IFile[] files;
        java.net.URI valURI = java.net.URI.create(val);
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(valURI);
        if (containers.length == 1) {
            val = URI.createPlatformResourceURI((String)containers[0].getFullPath().toString(), (boolean)true).toString();
        }
        if ((files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(valURI)).length == 1) {
            val = URI.createPlatformResourceURI((String)files[0].getFullPath().toString(), (boolean)true).toString();
        }
        PATH_MAP.put(var, val);
        Iterator i = PathmapManager.allInstances().iterator();
        while (i.hasNext()) {
            ((PathmapManager)i.next()).resyncEntries(true);
        }
    }

    public IStatus addPathVariable(String name, String value) {
        PathmapManager.setPathVariable(name, value);
        return Status.OK_STATUS;
    }

    public static void unsetPathVariable(String var) {
        PATH_MAP.remove(var);
        Iterator i = PathmapManager.allInstances().iterator();
        while (i.hasNext()) {
            ((PathmapManager)i.next()).resyncEntries(true);
        }
    }

    public IStatus removePathVariable(String name) {
        PathmapManager.unsetPathVariable(name);
        return Status.OK_STATUS;
    }

    private ResourceSet getResourceSet() {
        return (ResourceSet)this.getTarget();
    }

    public String getPathVariable(String var) {
        int len;
        String val;
        URI valURI;
        URI varURI = PathmapManager.makeURI(var);
        if (varURI != null && (valURI = (URI)this.getURIMap().get(varURI)) != null && (val = valURI.toString()) != null && (len = val.length()) != 0) {
            if (val.charAt(len - 1) == '/') {
                val = val.substring(0, len - 1);
            }
            return val;
        }
        return "";
    }

    private static Map configure() {
        HashMap<String, String> paths = new HashMap<String, String>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getExtensionPoint(EMFCorePlugin.getPluginId(), "Pathmaps").getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement element = configs[i];
            String var = element.getAttribute(NAME);
            if (var != null && var.length() != 0) {
                URL url;
                Bundle bundle;
                String plugin;
                String path = element.getAttribute(PATH);
                if (path == null) {
                    path = "";
                }
                if ((plugin = element.getAttribute(PLUGIN)) == null || plugin.length() == 0) {
                    plugin = element.getDeclaringExtension().getNamespaceIdentifier();
                }
                if ((bundle = Platform.getBundle((String)plugin)) != null && (url = bundle.getEntry(path)) != null) {
                    try {
                        url = FileLocator.resolve((URL)url);
                        if (url != null) {
                            paths.put(var, URI.createURI((String)url.toString(), (boolean)true).toString());
                        }
                    }
                    catch (IOException e) {
                        EMFCorePlugin eMFCorePlugin = EMFCorePlugin.getDefault();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.gmf.runtime.emf.core.internal.resources.PathmapManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Trace.catching((Plugin)eMFCorePlugin, (String)EMFCoreDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"configure", (Throwable)e);
                    }
                }
            }
            ++i;
        }
        return paths;
    }

    public void notifyChanged(Notification msg) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.ecore.resource.ResourceSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (msg.getFeatureID((Class)clazz) == 0) {
            switch (msg.getEventType()) {
                case 3: {
                    this.denormalize((Resource)msg.getNewValue(), this.getResourceSet().getURIConverter());
                    break;
                }
                case 5: {
                    List resources = (List)msg.getNewValue();
                    if (resources == null) break;
                    Iterator i = resources.iterator();
                    while (i.hasNext()) {
                        this.denormalize((Resource)msg.getNewValue(), this.getResourceSet().getURIConverter());
                    }
                    break;
                }
                case 4: {
                    this.normalize((Resource)msg.getOldValue(), this.getResourceSet().getURIConverter());
                    break;
                }
                case 6: {
                    List resources = (List)msg.getNewValue();
                    if (resources == null) break;
                    Iterator i = resources.iterator();
                    while (i.hasNext()) {
                        this.normalize((Resource)msg.getNewValue(), this.getResourceSet().getURIConverter());
                    }
                    break;
                }
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        ResourceSet rset = this.getResourceSet();
        if (rset != null) {
            this.resyncEntries(false);
        }
        super.setTarget(newTarget);
        rset = this.getResourceSet();
        if (rset != null) {
            this.resyncEntries(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resyncEntries(boolean resync) {
        URI key;
        HashMap<Resource, URI> savedURIs = new HashMap<Resource, URI>();
        ResourceSet rset = this.getResourceSet();
        if (rset == null) {
            return;
        }
        Iterator i = rset.getResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            URI uri = resource.getURI();
            savedURIs.put(resource, uri);
        }
        this.normalizeAll();
        Map uriMap = this.getURIMap();
        HashMap savedURIMap = new HashMap();
        Iterator i2 = uriMap.keySet().iterator();
        while (i2.hasNext()) {
            key = (URI)i2.next();
            if (key == null || "pathmap".equals(key.scheme())) continue;
            savedURIMap.put(key, uriMap.get(key));
        }
        this.getURIMap().clear();
        if (resync) {
            i2 = PATH_MAP;
            synchronized (i2) {
                Iterator i3 = PATH_MAP.entrySet().iterator();
                while (i3.hasNext()) {
                    Map.Entry entry = i3.next();
                    this.addEntry((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        i2 = savedURIMap.keySet().iterator();
        while (i2.hasNext()) {
            key = (URI)i2.next();
            if (key == null) continue;
            uriMap.put(key, savedURIMap.get(key));
        }
        if (resync) {
            this.denormalizeAll();
        }
        i2 = rset.getResources().iterator();
        while (i2.hasNext()) {
            URI savedURI;
            Resource resource = (Resource)i2.next();
            URI uri = resource.getURI();
            if (uri == (savedURI = (URI)savedURIs.get(resource)) || uri == null || uri.equals((Object)savedURI)) continue;
            Collection exports = EMFCoreUtil.getExports(resource);
            Iterator j = exports.iterator();
            while (j.hasNext()) {
                Resource export = (Resource)j.next();
                if (export.isModified()) continue;
                export.setModified(true);
            }
        }
    }

    private void addEntry(String var, String val) {
        URI varURI = PathmapManager.makeURI(var);
        if (varURI != null) {
            int len = val.length();
            if (len == 0) {
                return;
            }
            StringBuffer uri = new StringBuffer();
            uri.append(val);
            if (val.charAt(len - 1) != '/') {
                uri.append('/');
            }
            URI valURI = URI.createURI((String)uri.toString());
            this.getURIMap().put(varURI, valURI);
        }
    }

    private void normalizeAll() {
        ResourceSet rset = this.getResourceSet();
        URIConverter converter = rset.getURIConverter();
        if (converter != null) {
            Iterator i = rset.getResources().iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                this.normalize(resource, converter);
            }
        }
    }

    private void normalize(Resource resource, URIConverter converter) {
        URI uri = resource.getURI();
        if (uri == null) {
            return;
        }
        if ("pathmap".equals(uri.scheme()) && resource instanceof GMFResource) {
            ((GMFResource)resource).setRawURI(converter.normalize(uri));
        }
    }

    private void denormalizeAll() {
        ResourceSet rset = this.getResourceSet();
        URIConverter converter = rset.getURIConverter();
        if (converter != null) {
            Iterator i = rset.getResources().iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                this.denormalize(resource, converter);
            }
        }
    }

    private void denormalize(Resource resource, URIConverter converter) {
        URI uri = resource.getURI();
        if (uri == null) {
            return;
        }
        if (resource instanceof GMFResource) {
            ((GMFResource)resource).setURI(converter.normalize(uri));
        }
    }

    private static URI makeURI(String var) {
        int len = var.length();
        if (len == 0) {
            return null;
        }
        StringBuffer uri = new StringBuffer();
        uri.append("pathmap");
        uri.append(':');
        uri.append('/');
        uri.append('/');
        uri.append(var);
        if (var.charAt(len - 1) != '/') {
            uri.append('/');
        }
        return URI.createURI((String)uri.toString());
    }

    private Map getURIMap() {
        return this.getResourceSet().getURIConverter().getURIMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI denormalizeURI(URI uri) {
        String uriAsString = uri.toString();
        String maxValueString = null;
        String maxKey = null;
        Map map = PATH_MAP;
        synchronized (map) {
            Iterator i = PATH_MAP.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String valueString = (String)entry.getValue();
                if (valueString.endsWith("/")) {
                    valueString = valueString.substring(0, valueString.length() - 1);
                }
                if (!uriAsString.startsWith(valueString) || maxValueString != null && maxValueString.length() >= valueString.length()) continue;
                maxValueString = valueString;
                maxKey = (String)entry.getKey();
            }
        }
        if (maxKey != null) {
            URI valueURI = URI.createURI(maxValueString);
            URI pathmapURI = PathmapManager.makeURI(maxKey);
            int segmentStart = valueURI.segmentCount();
            int segmentCount = uri.segmentCount();
            int j = segmentStart;
            while (j < segmentCount) {
                pathmapURI = pathmapURI.appendSegment(uri.segment(j));
                ++j;
            }
            return pathmapURI;
        }
        return uri;
    }
}

