/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.validation;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.lite.validation.IValidationStateListener;
import org.eclipse.gmf.runtime.lite.validation.ValidationState;
import org.eclipse.gmf.runtime.lite.validation.ValidationStateEvent;
import org.eclipse.gmf.runtime.lite.validation.ViolationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationStateManager {
    private ArrayList<IValidationStateListener> myListeners = new ArrayList();
    private HashMap<URI, WeakReference<ValidationState>> myValidationStates = new HashMap();

    public void addValidationStateListener(IValidationStateListener listener) {
        if (listener != null && !this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeValidationStateListener(IValidationStateListener listener) {
        this.myListeners.remove(listener);
    }

    public ValidationState getValidationState(URI diagramUri) {
        WeakReference<ValidationState> ref = this.myValidationStates.get(diagramUri);
        ValidationState result = null;
        if (ref != null) {
            result = (ValidationState)ref.get();
        }
        if (result == null) {
            result = new ValidationState(this, diagramUri);
            this.myValidationStates.put(diagramUri, new WeakReference<ValidationState>(result));
        }
        return result;
    }

    void fireValidationStateChanged(ValidationState source, Map<URI, Collection<ViolationDescriptor>> oldViolations, Map<URI, Collection<ViolationDescriptor>> newViolations) {
        if (this.myListeners.isEmpty()) {
            return;
        }
        ValidationStateEvent evt = new ValidationStateEvent(source, oldViolations, newViolations);
        for (IValidationStateListener next : new ArrayList<IValidationStateListener>(this.myListeners)) {
            next.validationStateChanged(evt);
        }
    }
}

