/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.type.GeoshapeType;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.diagram.ui.type.DiagramNotationType;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractConnectionTests;
import org.eclipse.gmf.tests.runtime.diagram.ui.DiagramTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.AbstractPresentationTestFixture;

public class ConnectorTests
extends AbstractConnectionTests {
    public static Test suite() {
        return new TestSuite(ConnectorTests.class);
    }

    public ConnectorTests(String arg0) {
        super(arg0);
    }

    protected void setTestFixture() {
        this.testFixture = new DiagramTestFixture();
    }

    protected AbstractPresentationTestFixture getFixture() {
        return (AbstractPresentationTestFixture)this.testFixture;
    }

    public void testSelfConnector_RATLC00533255() throws Exception {
        try {
            try {
                this.getFixture().openDiagram();
                NoteEditPart note1EP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(10, 10));
                ConnectionNodeEditPart line = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note1EP, (IElementType)GeoshapeType.LINE);
                this.flushEventQueue();
                PointList pointList = line.getConnectionFigure().getPoints();
                ConnectorTests.assertTrue((pointList.size() > 1 ? 1 : 0) != 0);
                ConnectorTests.assertFalse((boolean)pointList.getFirstPoint().equals((Object)pointList.getLastPoint()));
                Point copySrcPoint = pointList.getFirstPoint().getCopy();
                copySrcPoint.translate(0, 20);
                class MyConnectorEndpointTracker
                extends ConnectionEndpointTracker {
                    private Point location;

                    public MyConnectorEndpointTracker(ConnectionEditPart cep, Point location) {
                        super(cep);
                        this.location = location;
                    }

                    public void updateTargetRequest() {
                        super.updateTargetRequest();
                    }

                    public Request getTargetRequest() {
                        return super.getTargetRequest();
                    }

                    public Point getLocation() {
                        return this.location;
                    }

                    public boolean updateTargetUnderMouse() {
                        return false;
                    }
                }
                MyConnectorEndpointTracker tracker = new MyConnectorEndpointTracker((ConnectionEditPart)line, copySrcPoint);
                tracker.setCommandName("Reconnection source");
                tracker.setConnectionEditPart((ConnectionEditPart)line);
                tracker.updateTargetRequest();
                ReconnectRequest reconnectRequest = (ReconnectRequest)tracker.getTargetRequest();
                reconnectRequest.setTargetEditPart((EditPart)note1EP);
                Command command = note1EP.getCommand((Request)reconnectRequest);
                this.getCommandStack().execute(command);
                this.flushEventQueue();
                PointList pointList_2 = line.getConnectionFigure().getPoints();
                ConnectorTests.assertTrue((pointList.size() > 1 ? 1 : 0) != 0);
                Point srcPoint_2 = pointList_2.getFirstPoint();
                Point targetPoint_2 = pointList_2.getLastPoint();
                ConnectorTests.assertFalse((boolean)srcPoint_2.equals((Object)targetPoint_2));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getFixture().closeDiagram();
            }
        }
        finally {
            this.getFixture().closeDiagram();
        }
    }

    public void testReorientRectilinear_bugzilla113003() throws Exception {
        try {
            try {
                this.getFixture().openDiagram();
                NoteEditPart note1EP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(10, 10));
                NoteEditPart note2EP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(300, 10));
                ConnectionNodeEditPart line = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note2EP, (IElementType)GeoshapeType.LINE);
                this.flushEventQueue();
                ChangePropertyValueRequest request = new ChangePropertyValueRequest("", Properties.ID_ROUTING, (Object)Routing.RECTILINEAR_LITERAL);
                Command cmd = line.getCommand((Request)request);
                this.getCommandStack().execute(cmd);
                PointList pointList = line.getConnectionFigure().getPoints();
                PointList newpts = new PointList(3);
                newpts.addPoint(new Point(pointList.getFirstPoint()));
                newpts.addPoint(new Point(new Point(150, 100)));
                newpts.addPoint(new Point(pointList.getLastPoint()));
                Point r1 = new Point(pointList.getFirstPoint());
                Point r2 = new Point(pointList.getLastPoint());
                SetConnectionBendpointsCommand bendpointsChanged = new SetConnectionBendpointsCommand(this.getTestFixture().getEditingDomain());
                bendpointsChanged.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)line.getNotationView()));
                bendpointsChanged.setNewPointList(newpts, r1, r2);
                this.getCommandStack().execute((Command)new ICommandProxy((ICommand)bendpointsChanged));
                this.flushEventQueue();
                ConnectorTests.assertEquals((String)"Wrong number of points.", (int)5, (int)line.getConnectionFigure().getPoints().size());
                ConnectorTests.assertTrue((pointList.size() > 1 ? 1 : 0) != 0);
                ConnectorTests.assertFalse((boolean)pointList.getFirstPoint().equals((Object)pointList.getLastPoint()));
                Point newSrcPoint = new Point(500, 500);
                class MyConnectorEndpointTracker
                extends ConnectionEndpointTracker {
                    private Point location;

                    public MyConnectorEndpointTracker(ConnectionEditPart cep, Point location) {
                        super(cep);
                        this.location = location;
                    }

                    public boolean handleDragInProgress() {
                        return super.handleDragInProgress();
                    }

                    public Request getTargetRequest() {
                        return super.getTargetRequest();
                    }

                    public Point getLocation() {
                        return this.location;
                    }

                    public boolean updateTargetUnderMouse() {
                        return false;
                    }
                }
                MyConnectorEndpointTracker tracker = new MyConnectorEndpointTracker((ConnectionEditPart)line, newSrcPoint);
                tracker.setCommandName("Reconnection source");
                tracker.setConnectionEditPart((ConnectionEditPart)line);
                tracker.handleDragInProgress();
                line.getConnectionFigure().revalidate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getFixture().closeDiagram();
            }
        }
        finally {
            this.getFixture().closeDiagram();
        }
    }

    public void testRectilinearRoutingToConnection() throws Exception {
        try {
            try {
                this.getFixture().openDiagram();
                final ShapeEditPart note1EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100));
                final ShapeEditPart note2EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(200, 300));
                final ShapeEditPart note3EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(300, 100));
                this.flushEventQueue();
                ConnectionNodeEditPart targetLineEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note2EP, (IElementType)GeoshapeType.LINE);
                ConnectionNodeEditPart lineToTestEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note3EP, (IGraphicalEditPart)targetLineEP, (IElementType)GeoshapeType.LINE);
                ChangePropertyValueRequest request = new ChangePropertyValueRequest("", Properties.ID_ROUTING, (Object)Routing.RECTILINEAR_LITERAL);
                Command cmd = lineToTestEP.getCommand((Request)request);
                this.getCommandStack().execute(cmd);
                this.flushEventQueue();
                this.moveShapeAndTestLine(note3EP, lineToTestEP, new LineTester(){

                    public void testLine(ConnectionEditPart lineEP) {
                        if (!ConnectorTests.this.areEndsConnected(lineEP)) {
                            ConnectorTests.this.failWithMessage("ends not connected", lineEP, note1EP, note2EP, note3EP);
                        } else if (!ConnectorTests.this.isRectilinear(lineEP)) {
                            ConnectorTests.this.failWithMessage("not rectilinear", lineEP, note1EP, note2EP, note3EP);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getFixture().closeDiagram();
            }
        }
        finally {
            this.getFixture().closeDiagram();
        }
    }

    public void testRectilinearRoutingFromConnection() throws Exception {
        try {
            try {
                this.getFixture().openDiagram();
                final ShapeEditPart note1EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100));
                final ShapeEditPart note2EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(200, 300));
                final ShapeEditPart note3EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(300, 100));
                this.flushEventQueue();
                ConnectionNodeEditPart sourceLineEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note2EP, (IElementType)GeoshapeType.LINE);
                ConnectionNodeEditPart lineToTestEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)sourceLineEP, (IGraphicalEditPart)note3EP, (IElementType)GeoshapeType.LINE);
                ChangePropertyValueRequest request = new ChangePropertyValueRequest("", Properties.ID_ROUTING, (Object)Routing.RECTILINEAR_LITERAL);
                Command cmd = lineToTestEP.getCommand((Request)request);
                this.getCommandStack().execute(cmd);
                this.flushEventQueue();
                this.moveShapeAndTestLine(note3EP, lineToTestEP, new LineTester(){

                    public void testLine(ConnectionEditPart lineEP) {
                        if (!ConnectorTests.this.areEndsConnected(lineEP)) {
                            ConnectorTests.this.failWithMessage("ends not connected", lineEP, note1EP, note2EP, note3EP);
                        } else if (!ConnectorTests.this.isRectilinear(lineEP)) {
                            ConnectorTests.this.failWithMessage("not rectilinear", lineEP, note1EP, note2EP, note3EP);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getFixture().closeDiagram();
            }
        }
        finally {
            this.getFixture().closeDiagram();
        }
    }

    public void testObliqueRoutingToConnection() throws Exception {
        try {
            try {
                this.getFixture().openDiagram();
                final ShapeEditPart note1EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100));
                final ShapeEditPart note2EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(200, 300));
                final ShapeEditPart note3EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(300, 100));
                this.flushEventQueue();
                ConnectionNodeEditPart targetLineEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note2EP, (IElementType)GeoshapeType.LINE);
                ConnectionNodeEditPart lineToTestEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note3EP, (IGraphicalEditPart)targetLineEP, (IElementType)GeoshapeType.LINE);
                this.flushEventQueue();
                this.moveShapeAndTestLine(note3EP, lineToTestEP, new LineTester(){

                    public void testLine(ConnectionEditPart lineEP) {
                        if (!ConnectorTests.this.areEndsConnected(lineEP)) {
                            ConnectorTests.this.failWithMessage("ends not connected", lineEP, note1EP, note2EP, note3EP);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getFixture().closeDiagram();
            }
        }
        finally {
            this.getFixture().closeDiagram();
        }
    }

    public void testObliqueRoutingFromConnection() throws Exception {
        try {
            try {
                this.getFixture().openDiagram();
                final ShapeEditPart note1EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100));
                final ShapeEditPart note2EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(200, 300));
                final ShapeEditPart note3EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(300, 100));
                this.flushEventQueue();
                ConnectionNodeEditPart sourceLineEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note2EP, (IElementType)GeoshapeType.LINE);
                ConnectionNodeEditPart lineToTestEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)sourceLineEP, (IGraphicalEditPart)note3EP, (IElementType)GeoshapeType.LINE);
                this.flushEventQueue();
                this.moveShapeAndTestLine(note3EP, lineToTestEP, new LineTester(){

                    public void testLine(ConnectionEditPart lineEP) {
                        if (!ConnectorTests.this.areEndsConnected(lineEP)) {
                            ConnectorTests.this.failWithMessage("ends not connected", lineEP, note1EP, note2EP, note3EP);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getFixture().closeDiagram();
            }
        }
        finally {
            this.getFixture().closeDiagram();
        }
    }

    public void testConnectionBendpoints() throws Exception {
        try {
            try {
                this.getFixture().openDiagram();
                ShapeEditPart note1EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100));
                ShapeEditPart note2EP = this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(200, 300));
                this.flushEventQueue();
                ConnectionNodeEditPart lineEP = (ConnectionNodeEditPart)this.getFixture().createConnectorUsingTool((IGraphicalEditPart)note1EP, (IGraphicalEditPart)note2EP, (IElementType)GeoshapeType.LINE);
                this.flushEventQueue();
                PointList pointList = lineEP.getConnectionFigure().getPoints().getCopy();
                Point pt1 = pointList.getFirstPoint();
                Point pt2 = pointList.getLastPoint();
                Point bend = new Point((pt1.x + pt2.x) / 2, pt1.y);
                pointList.insertPoint(bend, 1);
                SetConnectionBendpointsCommand bendpointsChanged = new SetConnectionBendpointsCommand(this.getTestFixture().getEditingDomain());
                bendpointsChanged.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)lineEP.getNotationView()));
                bendpointsChanged.setNewPointList(pointList, lineEP.getConnectionFigure().getSourceAnchor().getReferencePoint(), lineEP.getConnectionFigure().getTargetAnchor().getReferencePoint());
                this.getCommandStack().execute((Command)new ICommandProxy((ICommand)bendpointsChanged));
                this.flushEventQueue();
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the model", (int)3, (int)((RelativeBendpoints)((Edge)lineEP.getNotationView()).getBendpoints()).getPoints().size());
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the figure", (int)3, (int)lineEP.getConnectionFigure().getPoints().size());
                pointList = lineEP.getConnectionFigure().getPoints().getCopy();
                pt1 = pointList.getFirstPoint();
                pt2 = pointList.getLastPoint();
                bend = new Point((pt1.x + pt2.x) / 4, (pt1.y + pt2.y) / 2);
                pointList.insertPoint(bend, 2);
                bendpointsChanged = new SetConnectionBendpointsCommand(this.getTestFixture().getEditingDomain());
                bendpointsChanged.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)lineEP.getNotationView()));
                bendpointsChanged.setNewPointList(pointList, lineEP.getConnectionFigure().getSourceAnchor().getReferencePoint(), lineEP.getConnectionFigure().getTargetAnchor().getReferencePoint());
                this.getCommandStack().execute((Command)new ICommandProxy((ICommand)bendpointsChanged));
                this.flushEventQueue();
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the model", (int)4, (int)((RelativeBendpoints)((Edge)lineEP.getNotationView()).getBendpoints()).getPoints().size());
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the figure", (int)4, (int)lineEP.getConnectionFigure().getPoints().size());
                this.getCommandStack().undo();
                this.flushEventQueue();
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the model", (int)3, (int)((RelativeBendpoints)((Edge)lineEP.getNotationView()).getBendpoints()).getPoints().size());
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the figure", (int)3, (int)lineEP.getConnectionFigure().getPoints().size());
                this.getCommandStack().redo();
                this.flushEventQueue();
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the model", (int)4, (int)((RelativeBendpoints)((Edge)lineEP.getNotationView()).getBendpoints()).getPoints().size());
                ConnectorTests.assertEquals((String)"Wrong number of bendpoints for the figure", (int)4, (int)lineEP.getConnectionFigure().getPoints().size());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getFixture().closeDiagram();
            }
        }
        finally {
            this.getFixture().closeDiagram();
        }
    }

    private void moveShapeAndTestLine(ShapeEditPart shapeToMoveEP, ConnectionNodeEditPart lineToTestEP, LineTester lineTester) {
        lineTester.testLine((ConnectionEditPart)lineToTestEP);
        ChangeBoundsRequest moveRequest = new ChangeBoundsRequest((Object)"move");
        moveRequest.setEditParts((EditPart)shapeToMoveEP);
        int i = 0;
        while (i <= 50) {
            moveRequest.setMoveDelta(new Point(0, 5));
            this.getCommandStack().execute(shapeToMoveEP.getCommand((Request)moveRequest));
            this.flushEventQueue();
            lineTester.testLine((ConnectionEditPart)lineToTestEP);
            ++i;
        }
        i = 0;
        while (i <= 50) {
            moveRequest.setMoveDelta(new Point(-5, 0));
            this.getCommandStack().execute(shapeToMoveEP.getCommand((Request)moveRequest));
            this.flushEventQueue();
            lineTester.testLine((ConnectionEditPart)lineToTestEP);
            ++i;
        }
        i = 0;
        while (i <= 50) {
            moveRequest.setMoveDelta(new Point(0, -5));
            this.getCommandStack().execute(shapeToMoveEP.getCommand((Request)moveRequest));
            this.flushEventQueue();
            lineTester.testLine((ConnectionEditPart)lineToTestEP);
            ++i;
        }
    }

    private boolean areEndsConnected(ConnectionEditPart lineEP) {
        IFigure targetFigure;
        Point firstPoint = ((Connection)lineEP.getFigure()).getPoints().getFirstPoint();
        Point lastPoint = ((Connection)lineEP.getFigure()).getPoints().getLastPoint();
        Dimension buffer = new Dimension(3, 3);
        lineEP.getFigure().translateToRelative((Translatable)buffer);
        IFigure sourceFigure = ((IGraphicalEditPart)lineEP.getSource()).getFigure();
        if (sourceFigure instanceof Connection) {
            PointList points = ((Connection)sourceFigure).getPoints();
            int index = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)points, (Point)firstPoint);
            LineSeg lineSeg = (LineSeg)PointListUtilities.getLineSegments((PointList)points).get(index - 1);
            if (!lineSeg.containsPoint(firstPoint, buffer.height * 2)) {
                return false;
            }
        } else {
            Rectangle bounds = sourceFigure.getBounds().getCopy();
            bounds.expand(buffer.width, buffer.height);
            if (!bounds.contains(firstPoint)) {
                return false;
            }
        }
        if ((targetFigure = ((IGraphicalEditPart)lineEP.getTarget()).getFigure()) instanceof Connection) {
            PointList points = ((Connection)targetFigure).getPoints();
            int index = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)points, (Point)lastPoint);
            LineSeg lineSeg = (LineSeg)PointListUtilities.getLineSegments((PointList)points).get(index - 1);
            if (!lineSeg.containsPoint(lastPoint, buffer.height * 2)) {
                return false;
            }
        } else {
            Rectangle bounds = targetFigure.getBounds().getCopy();
            bounds.expand(buffer.width, buffer.height);
            if (!bounds.contains(lastPoint)) {
                return false;
            }
        }
        return true;
    }

    private boolean isRectilinear(ConnectionEditPart lineEP) {
        PointList points = ((Connection)lineEP.getFigure()).getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            Point ptCurrent = points.getPoint(i);
            Point ptNext = points.getPoint(i + 1);
            if (ptCurrent.x != ptNext.x && ptCurrent.y != ptNext.y) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void failWithMessage(String message, ConnectionEditPart lineEP, ShapeEditPart note1EP, ShapeEditPart note2EP, ShapeEditPart note3EP) {
        System.out.println("------ " + message);
        System.out.println("Issue can be reproduced with notes in the following locations:");
        System.out.println("note1: " + note1EP.getFigure().getBounds());
        System.out.println("note2: " + note2EP.getFigure().getBounds());
        System.out.println("note3: " + note3EP.getFigure().getBounds());
        System.out.println("connection start: " + ((Connection)lineEP.getFigure()).getPoints().getFirstPoint());
        System.out.println("connection end: " + ((Connection)lineEP.getFigure()).getPoints().getLastPoint());
        ConnectorTests.fail((String)"See console for details.");
    }

    private static interface LineTester {
        public void testLine(ConnectionEditPart var1);
    }
}

