/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class JETSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    private IPreferenceStore preferenceStore;
    private Color foregroundColor;
    private Color backgroundColor;
    private Color selectionForegroundColor;
    private Color selectionBackgroundColor;

    public JETSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles, IPreferenceStore store) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.setPreferenceStore(store);
    }

    public void setPreferenceStore(IPreferenceStore store) {
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.preferenceStore = store;
        if (this.preferenceStore != null) {
            this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    private void initializeViewerColors() {
        if (this.preferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            if (styledText == null || styledText.isDisposed()) {
                return;
            }
            Color color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.foregroundColor != null) {
                this.foregroundColor.dispose();
            }
            this.foregroundColor = color;
            color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.backgroundColor != null) {
                this.backgroundColor.dispose();
            }
            this.backgroundColor = color;
            color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.selectionForegroundColor != null) {
                this.selectionForegroundColor.dispose();
            }
            this.selectionForegroundColor = color;
            color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.selectionBackgroundColor != null) {
                this.selectionBackgroundColor.dispose();
            }
            this.selectionBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
            this.initializeViewerColors();
        }
    }
}

