/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.core.url.URLUtility;
import org.eclipse.jet.internal.extensionpoints.TransformData;
import org.eclipse.jet.internal.extensionpoints.TransformDataFactory;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.AdditionalBundleLocationProvider;
import org.eclipse.jet.internal.runtime.DeployedJETBundleProvider;
import org.eclipse.jet.internal.runtime.DynamicJETBundleDescriptor;
import org.eclipse.jet.internal.runtime.IJETBundleProvider;
import org.eclipse.jet.internal.runtime.InstalledJETBundleProvider;
import org.eclipse.jet.internal.runtime.JET2TemplateLoaderImpl;
import org.eclipse.jet.internal.runtime.JETBundleManifest;
import org.eclipse.jet.internal.runtime.NotABundleException;
import org.eclipse.jet.internal.runtime.ProjectJETBundleProvider;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.transform.IJETBundleManager;
import org.eclipse.jet.transform.IJETRunnable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class JETBundleManager
implements IJETBundleManager {
    private InstalledJETBundleProvider installedBundleProvider;
    private ProjectJETBundleProvider projectBundleProvider;
    private DeployedJETBundleProvider deployedBundleProvider;
    private AdditionalBundleLocationProvider additionalBundleLocationProvider;
    private IJETBundleProvider[] providerSearchOrder;
    private Map bundlesById = new HashMap();

    private static void ensureStreamClosed(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static JETBundleManifest loadManifest(URL pluginURL) throws IOException, NotABundleException {
        JETBundleManifest jETBundleManifest;
        URL manifestURL = new URL(pluginURL, "META-INF/MANIFEST.MF");
        InputStream manifestStream = null;
        try {
            manifestStream = manifestURL.openStream();
            Manifest m = new Manifest(manifestStream);
            jETBundleManifest = new JETBundleManifest(JETBundleManager.manifestToProperties(m.getMainAttributes()));
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            JETBundleManager.ensureStreamClosed(manifestStream);
            throw throwable;
        }
        JETBundleManager.ensureStreamClosed(manifestStream);
        return jETBundleManifest;
    }

    public static IJETBundleDescriptor getJETBundleDescriptorForJAR(URL bundleURL) {
        DynamicJETBundleDescriptor descriptor = null;
        try {
            URL jarURL = URLUtility.jarRootEntryURL((URL)bundleURL);
            JETBundleManifest manifest = JETBundleManager.loadManifest(jarURL);
            TransformData transformData = TransformDataFactory.INSTANCE.createTransformData(manifest.getTransformId(), jarURL);
            descriptor = new DynamicJETBundleDescriptor(manifest, transformData, jarURL, bundleURL);
            if (descriptor.getTemplateLoaderClass() == null) {
                descriptor = null;
            }
        }
        catch (MalformedURLException e) {
            InternalJET2Platform.logError("Failed to correctly format a jar URL. bundleURL = " + bundleURL.toExternalForm(), e);
        }
        catch (IOException iOException) {
        }
        catch (NotABundleException notABundleException) {}
        return descriptor;
    }

    private static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public IJETBundleDescriptor[] getAllJETBundleDescriptors() {
        String[] allIds = this.getAllTransformIds();
        IJETBundleDescriptor[] result = new IJETBundleDescriptor[allIds.length];
        int i = 0;
        while (i < allIds.length) {
            result[i] = this.getDescriptor(allIds[i]);
            ++i;
        }
        return result;
    }

    public IJETBundleDescriptor getDescriptor(String id) {
        IJETBundleDescriptor descriptor = null;
        int i = 0;
        while (i < this.providerSearchOrder.length && descriptor == null) {
            IJETBundleProvider provider = this.providerSearchOrder[i];
            descriptor = provider.getDescriptor(id);
            ++i;
        }
        return descriptor;
    }

    public IJETBundleDescriptor getDescriptorForProject(String name) {
        return this.projectBundleProvider.getDescriptorForProject(name);
    }

    public void shutdown() {
        InternalJET2Platform.IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(this.getClass(), "shutdown()");
        Iterator i = this.bundlesById.values().iterator();
        while (i.hasNext()) {
            BundleWrapper wrappedBundle = (BundleWrapper)i.next();
            try {
                wrappedBundle.getProvider().unload(wrappedBundle.getBundle());
            }
            catch (BundleException e) {
                InternalJET2Platform.logError(JET2Messages.JET2Bundle_CouldNotLoadJetBundle, (Exception)((Object)e));
            }
        }
        this.bundlesById.clear();
        this.installedBundleProvider.shutdown();
        this.installedBundleProvider = null;
        this.projectBundleProvider.shutdown();
        this.projectBundleProvider = null;
        this.deployedBundleProvider.shutdown();
        this.deployedBundleProvider = null;
        this.additionalBundleLocationProvider.shutdown();
        this.additionalBundleLocationProvider = null;
        this.providerSearchOrder = null;
        timer.done();
    }

    public void startup() {
        InternalJET2Platform.IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(this.getClass(), "startup()");
        this.installedBundleProvider = new InstalledJETBundleProvider();
        this.installedBundleProvider.startup();
        this.projectBundleProvider = new ProjectJETBundleProvider();
        this.projectBundleProvider.startup();
        this.deployedBundleProvider = new DeployedJETBundleProvider();
        this.deployedBundleProvider.startup();
        this.additionalBundleLocationProvider = new AdditionalBundleLocationProvider();
        this.additionalBundleLocationProvider.startup();
        this.providerSearchOrder = new IJETBundleProvider[]{this.installedBundleProvider, this.projectBundleProvider, this.additionalBundleLocationProvider, this.deployedBundleProvider};
        timer.done();
    }

    public String getProjectForId(String id) {
        return this.projectBundleProvider.getProjectForId(id);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String id, IJETRunnable runnable, IProgressMonitor monitor) throws BundleException {
        monitor.beginTask(JET2Messages.JET2Platform_Executing, 100);
        try {
            this.connect(id, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            try {
                IJETBundleDescriptor descriptor = this.getDescriptor(id);
                JET2TemplateLoader loader = this.getTemplateLoader(id);
                runnable.run(descriptor, loader, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.disconnect(id);
                throw throwable;
            }
            {
                Object var6_8 = null;
                this.disconnect(id);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        monitor.done();
    }

    private IJETBundleProvider getProvider(String id) {
        int i = 0;
        while (i < this.providerSearchOrder.length) {
            IJETBundleProvider provider = this.providerSearchOrder[i];
            if (this.providerSearchOrder[i].getDescriptor(id) != null) {
                return provider;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String id, IProgressMonitor monitor) throws BundleException {
        BundleWrapper wrappedBundle = null;
        Map map = this.bundlesById;
        synchronized (map) {
            IJETBundleProvider provider;
            wrappedBundle = (BundleWrapper)this.bundlesById.get(id);
            if (wrappedBundle == null && (provider = this.getProvider(id)) != null) {
                Bundle bundle = provider.load(id, monitor);
                wrappedBundle = new BundleWrapper(provider, bundle);
                this.bundlesById.put(id, wrappedBundle);
            }
            if (wrappedBundle == null) {
                throw new BundleException(JET2Messages.TemplateBundleManager_CannotLoad);
            }
            wrappedBundle.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String id) {
        Map map = this.bundlesById;
        synchronized (map) {
            BundleWrapper wrappedBundle = (BundleWrapper)this.bundlesById.get(id);
            if (wrappedBundle == null) {
                return;
            }
            wrappedBundle.disconnect();
            if (wrappedBundle.isDisconnected()) {
                this.bundlesById.remove(id);
                try {
                    wrappedBundle.getProvider().unload(wrappedBundle.getBundle());
                }
                catch (BundleException e) {
                    InternalJET2Platform.logError(JET2Messages.JET2Bundle_CouldNotLoadJetBundle, (Exception)((Object)e));
                }
            }
        }
    }

    private URL getTemplateMapURL(String id) {
        BundleWrapper wrappedBundle = (BundleWrapper)this.bundlesById.get(id);
        if (wrappedBundle != null) {
            return wrappedBundle.getBundle().getResource("jetTemplateMap.properties");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JET2TemplateLoader getTemplateLoader(String id) throws BundleException {
        Map map = this.bundlesById;
        synchronized (map) {
            BundleWrapper wrappedBundle = (BundleWrapper)this.bundlesById.get(id);
            if (wrappedBundle != null) {
                try {
                    Class loaderClass;
                    Object newInstance;
                    URL mapURL = this.getTemplateMapURL(id);
                    if (mapURL != null) {
                        try {
                            JET2TemplateLoaderImpl loader = new JET2TemplateLoaderImpl(wrappedBundle.getBundle(), mapURL);
                            return loader;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((newInstance = (loaderClass = wrappedBundle.getBundle().loadClass(wrappedBundle.getProvider().getDescriptor(id).getTemplateLoaderClass())).newInstance()) instanceof JET2TemplateLoader) {
                        return (JET2TemplateLoader)newInstance;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new BundleException(JET2Messages.JET2Bundle_CouldNotLoadLoader, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new BundleException(JET2Messages.JET2Bundle_CouldNotInstantiateLoader, (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new BundleException(JET2Messages.JET2Bundle_CouldNotInstantiateLoader, (Throwable)e);
                }
            }
        }
        throw new BundleException(JET2Messages.JET2Bundle_CouldNotLoadLoader);
    }

    public String[] getAllTransformIds() {
        TreeSet<String> allIds = new TreeSet<String>();
        int i = 0;
        while (i < this.providerSearchOrder.length) {
            IJETBundleProvider provider = this.providerSearchOrder[i];
            Collection descriptors = provider.getAllJETBundleDescriptors();
            Iterator j = descriptors.iterator();
            while (j.hasNext()) {
                IJETBundleDescriptor descriptor = (IJETBundleDescriptor)j.next();
                if (descriptor.isPrivate()) continue;
                allIds.add(descriptor.getId());
            }
            ++i;
        }
        return allIds.toArray(new String[allIds.size()]);
    }

    private static class BundleWrapper {
        private final Bundle bundle;
        private int refCount;
        private final IJETBundleProvider provider;

        public BundleWrapper(IJETBundleProvider provider, Bundle bundle) {
            this.provider = provider;
            this.bundle = bundle;
            this.refCount = 0;
        }

        public void connect() {
            ++this.refCount;
        }

        public void disconnect() {
            --this.refCount;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public boolean isDisconnected() {
            return this.refCount <= 0;
        }

        public final IJETBundleProvider getProvider() {
            return this.provider;
        }
    }
}

