/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.baseimpl.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.CollectionTypeImpl;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTypeImpl
extends CollectionTypeImpl
implements Type {
    public ListTypeImpl(Type innerType, TypeSystem ts, String name) {
        super(innerType, ts, name);
    }

    @Override
    public boolean isInstance(Object o) {
        return o instanceof List;
    }

    @Override
    public Object newInstance() {
        return new ArrayList();
    }

    @Override
    public ParameterizedType cloneWithInnerType(Type innerType) {
        return (ParameterizedType)this.getTypeSystem().getListType(innerType);
    }

    @Override
    public Feature[] getContributedFeatures() {
        return new Feature[]{new OperationImpl(this, "get", this.getInnerType(), new Type[]{this.getTypeSystem().getIntegerType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                return ((List)target).get(((Number)params[0]).intValue());
            }
        }, new OperationImpl(this, "indexOf", this.getTypeSystem().getIntegerType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                return new Long(((List)target).indexOf(params[0]));
            }
        }, new OperationImpl(this, "first", this.getInnerType(), new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                List l;
                if (target instanceof List && (l = (List)target).size() > 0) {
                    return l.get(0);
                }
                return null;
            }
        }, new OperationImpl(this, "reverse", this.getTypeSystem().getCollectionType(this.getInnerType()), new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target instanceof List) {
                    ArrayList l = new ArrayList((List)target);
                    Collections.reverse(l);
                    return l;
                }
                return null;
            }
        }, new OperationImpl(this, "last", this.getInnerType(), new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                List l;
                if (target instanceof List && (l = (List)target).size() > 0) {
                    return l.get(l.size() - 1);
                }
                return null;
            }
        }, new OperationImpl(this, "withoutFirst", (Type)this, new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target instanceof List) {
                    List l = (List)target;
                    ArrayList r = new ArrayList();
                    int i = 1;
                    while (i < l.size()) {
                        r.add(l.get(i));
                        ++i;
                    }
                    return r;
                }
                return null;
            }
        }, new OperationImpl(this, "withoutLast", (Type)this, new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target instanceof List) {
                    List l = (List)target;
                    ArrayList r = new ArrayList();
                    int i = 0;
                    while (i < l.size() - 1) {
                        r.add(l.get(i));
                        ++i;
                    }
                    return r;
                }
                return null;
            }
        }};
    }

    @Override
    public Set<Type> getSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getCollectionType(this.getInnerType()));
    }
}

