/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoParser {
    private Map<File, AcceleoParserProblems> problems;

    public void parse(List<File> inputFiles, List<URI> outputURIs, List<URI> dependenciesURIs) {
        ArrayList<AcceleoFile> acceleoFiles = new ArrayList<AcceleoFile>();
        for (File inputFile : inputFiles) {
            acceleoFiles.add(new AcceleoFile(inputFile, AcceleoFile.simpleModuleName(inputFile)));
        }
        this.parse(acceleoFiles, outputURIs, dependenciesURIs, (Monitor)new BasicMonitor());
    }

    public void parse(List<AcceleoFile> acceleoFiles, List<URI> outputURIs, List<URI> dependenciesURIs, Monitor monitor) {
        this.parse(acceleoFiles, outputURIs, dependenciesURIs, null, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public void parse(List<AcceleoFile> acceleoFiles, List<URI> outputURIs, List<URI> dependenciesURIs, Map<URI, URI> mapURIs, Monitor monitor) {
        monitor.beginTask(AcceleoParserMessages.getString("AcceleoParser.ParseFiles", new Object[]{acceleoFiles.size()}), acceleoFiles.size() * 3);
        oResourceSet = new ResourceSetImpl();
        newResources = new ArrayList<Resource>();
        sources = new ArrayList<AcceleoSourceBuffer>();
        itOutputURIs = outputURIs.iterator();
        allImportedFiles = new HashSet<String>();
        itAcceleoFiles = acceleoFiles.iterator();
        while (!monitor.isCanceled() && itAcceleoFiles.hasNext() && itOutputURIs.hasNext()) {
            acceleoFile = itAcceleoFiles.next();
            monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.ParseFileCST", new Object[]{acceleoFile.getMtlFile().getName()}));
            oURI = itOutputURIs.next();
            source = new AcceleoSourceBuffer(acceleoFile);
            sources.add(source);
            oResource = ModelUtils.createResource((URI)oURI, (ResourceSet)oResourceSet);
            newResources.add(oResource);
            source.createCST();
            for (ModuleImportsValue importValue : source.getCST().getImports()) {
                importedFileName = importValue.getName();
                if (importedFileName == null) continue;
                lastSegment = importedFileName.lastIndexOf("::");
                if (lastSegment > -1) {
                    importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
                }
                allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
            }
            for (ModuleExtendsValue extendValue : source.getCST().getExtends()) {
                importedFileName = extendValue.getName();
                if (importedFileName == null) continue;
                lastSegment = importedFileName.lastIndexOf("::");
                if (lastSegment > -1) {
                    importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
                }
                allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
            }
            source.createAST(oResource);
            monitor.worked(1);
        }
        itDependenciesURIs = dependenciesURIs.iterator();
        block7: while (!monitor.isCanceled() && itDependenciesURIs.hasNext()) {
            oURI = itDependenciesURIs.next();
            if (outputURIs.contains(oURI) || !allImportedFiles.contains(oURI.lastSegment())) continue;
            try {
                ModelUtils.load((URI)oURI, (ResourceSet)oResourceSet);
                continue;
            }
            catch (IOException v0) {
                iterator = sources.iterator();
                ** while (iterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                ((AcceleoSourceBuffer)iterator.next()).log(AcceleoParserMessages.getString("AcceleoParser.Error.InvalidAST", new Object[]{oURI.lastSegment()}), 0, -1);
                continue;
lbl53:
                // 1 sources

            }
        }
        itSources = sources.iterator();
        while (!monitor.isCanceled() && itSources.hasNext()) {
            source = (AcceleoSourceBuffer)itSources.next();
            if (source.getFile() != null) {
                monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.ParseFileAST", new Object[]{source.getFile().getName()}));
            }
            source.resolveAST();
            monitor.worked(1);
        }
        if (mapURIs != null) {
            for (Resource resource : oResourceSet.getResources()) {
                resourceURI = resource.getURI();
                if (resourceURI == null || (reusableURI = mapURIs.get(resourceURI)) == null) continue;
                resource.setURI(reusableURI);
            }
        }
        itSources = sources.iterator();
        while (!monitor.isCanceled() && itSources.hasNext()) {
            source = (AcceleoSourceBuffer)itSources.next();
            if (source.getFile() != null) {
                monitor.subTask(AcceleoParserMessages.getString("AcceleoParser.SaveAST", new Object[]{source.getFile().getName()}));
            }
            if ((eModule = source.getAST()) != null) {
                newResource = eModule.eResource();
                options = new HashMap<String, String>();
                encoding = source.getEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                options.put("ENCODING", encoding);
                try {
                    newResource.save(options);
                }
                catch (IOException e) {
                    source.log(AcceleoParserMessages.getString("AcceleoParser.Error.FileSaving", new Object[]{newResource.getURI().lastSegment(), e.getMessage()}), 0, -1);
                }
            } else {
                source.log(AcceleoParserMessages.getString("AcceleoParser.Error.InvalidAST", new Object[]{source.getFile().getName()}), 0, -1);
            }
            monitor.worked(1);
        }
        this.problems = new HashMap<File, AcceleoParserProblems>(sources.size());
        for (Object source : sources) {
            this.problems.put(source.getFile(), source.getProblems());
        }
        resources = oResourceSet.getResources().iterator();
        while (resources.hasNext()) {
            ((Resource)resources.next()).unload();
        }
    }

    public void parse(AcceleoSourceBuffer source, Resource resource, List<URI> dependenciesURIs) {
        int lastSegment;
        String importedFileName;
        ArrayList<URI> resourceSetURIs = new ArrayList<URI>();
        if (resource.getResourceSet() != null) {
            for (Resource otherResource : resource.getResourceSet().getResources()) {
                resourceSetURIs.add(otherResource.getURI());
            }
        }
        source.createCST();
        HashSet<String> allImportedFiles = new HashSet<String>();
        for (ModuleImportsValue importValue : source.getCST().getImports()) {
            importedFileName = importValue.getName();
            if (importedFileName == null) continue;
            lastSegment = importedFileName.lastIndexOf("::");
            if (lastSegment > -1) {
                importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
            }
            allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
        }
        for (ModuleExtendsValue extendValue : source.getCST().getExtends()) {
            importedFileName = extendValue.getName();
            if (importedFileName == null) continue;
            lastSegment = importedFileName.lastIndexOf("::");
            if (lastSegment > -1) {
                importedFileName = importedFileName.substring(lastSegment + "::".length()).trim();
            }
            allImportedFiles.add(String.valueOf(importedFileName) + '.' + "emtl");
        }
        source.createAST(resource);
        if (resource.getResourceSet() != null) {
            for (URI oURI : dependenciesURIs) {
                if (resourceSetURIs.contains(oURI) || !allImportedFiles.contains(oURI.lastSegment())) continue;
                try {
                    ModelUtils.load((URI)oURI, (ResourceSet)resource.getResourceSet());
                }
                catch (IOException iOException) {
                    source.log(AcceleoParserMessages.getString("AcceleoParser.Error.InvalidAST", oURI.lastSegment()), 0, -1);
                }
            }
        }
        source.resolveAST();
        if (source.getFile() != null) {
            this.problems = new HashMap<File, AcceleoParserProblems>(1);
            this.problems.put(source.getFile(), source.getProblems());
        }
    }

    public AcceleoParserProblems getProblems(File file) {
        if (this.problems != null) {
            return this.problems.get(file);
        }
        return null;
    }

    public AcceleoParserProblems getProblems(AcceleoFile acceleoFile) {
        if (this.problems != null && acceleoFile != null) {
            return this.problems.get(acceleoFile.getMtlFile());
        }
        return null;
    }
}

