/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.editor.EEPlugin;
import org.eclipse.emf.editor.MessageData;
import org.eclipse.emf.editor.ModelCheckor;
import org.eclipse.emf.editor.extxpt.ExtXptFacade;
import org.eclipse.emf.editor.extxpt.WorkspaceResourceManager;
import org.eclipse.emf.editor.provider.ClasspathUriResolver;
import org.eclipse.emf.editor.provider.DecoratingItemLabelProvider;
import org.eclipse.emf.editor.provider.ExtendedLabelProvider;
import org.eclipse.emf.editor.provider.ExtendedReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.editor.ui.EEDetailsPageProvider;
import org.eclipse.emf.editor.ui.EEMasterDetailsBlock;
import org.eclipse.emf.editor.ui.ImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEditor
extends EcoreEditor
implements ChangeListener {
    private static final String ESTRUCTURALFEATURE_KEY = EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName();
    private ManagedForm managedForm;
    private EEMasterDetailsBlock mdBlock;
    private IProject project;
    private ExtXptFacade facade;
    private ExtendedReflectiveItemProviderAdapterFactory.ExtendedReflectiveItemProvider extendedReflectiveItemProvider;

    public EEditor() {
        ImageRegistry.getDefault().addChangeListener(this);
    }

    public void dispose() {
        super.dispose();
        ImageRegistry.getDefault().removeChangeListener(this);
    }

    private void rejectFactory(ComposedAdapterFactory caf) {
        caf.removeAdapterFactory(caf.getFactoryForType((Object)EcorePackage.eINSTANCE.getEFactoryInstance().create(EcorePackage.Literals.EOBJECT)));
        ExtendedLabelProvider customProvider = new ExtendedLabelProvider(this.facade);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        ExtendedReflectiveItemProviderAdapterFactory extendedReflectiveItemProviderAdapterFactory = new ExtendedReflectiveItemProviderAdapterFactory(new DecoratingItemLabelProvider(customProvider, decorator), this.facade, this.getFile());
        caf.addAdapterFactory((AdapterFactory)extendedReflectiveItemProviderAdapterFactory);
        this.extendedReflectiveItemProvider = (ExtendedReflectiveItemProviderAdapterFactory.ExtendedReflectiveItemProvider)extendedReflectiveItemProviderAdapterFactory.createAdapter(null);
    }

    protected Composite createPageContainer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = new ScrolledForm(parent){

            public void reflow(boolean flushCache) {
            }
        };
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        form.setBackground(toolkit.getColors().getBackground());
        form.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        form.setFont(JFaceResources.getHeaderFont());
        toolkit.adapt(parent);
        this.managedForm = new ManagedForm(toolkit, form);
        this.managedForm.getForm().setText("Generic Editor - " + this.getFile().getName());
        this.managedForm.getToolkit().decorateFormHeading(this.managedForm.getForm().getForm());
        this.managedForm.getForm().getForm().setToolBarVerticalAlignment(128);
        this.managedForm.getForm().getForm().addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                try {
                    Object eventData = event.getHref();
                    if (eventData instanceof IMessage[]) {
                        final IMessage[] messages = (IMessage[])eventData;
                        EEditor.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                IMessage message;
                                Control c = null;
                                IMessage[] iMessageArray = messages;
                                if (messages.length != 0 && (message = iMessageArray[0]).getData() instanceof Collection) {
                                    EStructuralFeature f;
                                    List data = (List)message.getData();
                                    Object object = data.get(0);
                                    if (object != null) {
                                        EEditor.this.getViewer().setSelection((ISelection)new StructuredSelection(object), true);
                                    }
                                    if (data.size() > 1 && (f = (EStructuralFeature)data.get(1)) != null) {
                                        c = EEditor.this.mdBlock.findControl(ESTRUCTURALFEATURE_KEY, f);
                                    }
                                }
                                if (c != null && !c.isDisposed()) {
                                    c.forceFocus();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.mdBlock = new EEMasterDetailsBlock(new EEDetailsPageProvider(this)){

            protected void createMoreToolBarActions(IToolBarManager toolBarManager) {
                Action action = new Action("Check"){

                    public void run() {
                        EEditor.this.checkModel();
                    }
                };
                action.setImageDescriptor(EEPlugin.getDefault().getImageDescriptor("icons/complete_task.gif"));
                toolBarManager.add((IAction)action);
            }
        };
        this.mdBlock.createContent((IManagedForm)this.managedForm);
        Composite c = (Composite)this.mdBlock.getMasterSectionPart().getSection().getClient();
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof TreeSelection && !event.getSelection().isEmpty()) {
                    EEditor.this.managedForm.fireSelectionChanged((IFormPart)EEditor.this.mdBlock.getMasterSectionPart(), event.getSelection());
                }
            }
        });
        return c;
    }

    public void createPages() {
        this.initInternal();
        super.createPages();
    }

    private void initInternal() {
        this.project = this.getFile().getProject();
        this.editingDomain.getResourceSet().setURIConverter((URIConverter)new ExtensibleURIConverterImpl(){

            public URI normalize(URI uri) {
                if (ClasspathUriResolver.isClasspathUri(uri)) {
                    URI result = new ClasspathUriResolver().resolve((IResource)EEditor.this.project, uri);
                    if (ClasspathUriResolver.isClasspathUri(result)) {
                        throw new IllegalArgumentException("Couldn't find resource on classpath : " + result);
                    }
                    result = super.normalize(result);
                    return result;
                }
                return super.normalize(uri);
            }
        });
        this.facade = this.createExtXptFacade();
        if (this.editingDomain.getAdapterFactory() instanceof ComposedAdapterFactory) {
            ComposedAdapterFactory caf = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
            this.rejectFactory(caf);
        }
    }

    public void createModel() {
        try {
            super.createModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            try {
                this.checkModel();
                this.stateChanged(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                super.doSave(progressMonitor);
            }
        }
        finally {
            super.doSave(progressMonitor);
        }
    }

    public void checkModel() {
        final List<MessageData> messages = new ModelCheckor(this.facade).check(this.extendedReflectiveItemProvider, this.getEditingDomain(), this.getFile());
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IMessageManager messageManager = EEditor.this.managedForm.getMessageManager();
                messageManager.removeMessages();
                messageManager.setAutoUpdate(false);
                for (MessageData md : messages) {
                    messageManager.addMessage(md.getKey(), md.getMessage(), md.getData(), md.getStatus());
                }
                messageManager.update();
                messageManager.setAutoUpdate(true);
            }
        });
    }

    private ExtXptFacade createExtXptFacade() {
        final List<EPackage> packs = this.findMetaModelPackages();
        TypeSystemImpl ts = new TypeSystemImpl();
        ts.registerMetaModel((MetaModel)new EmfRegistryMetaModel(){

            protected EPackage[] allPackages() {
                return packs.toArray(new EPackage[packs.size()]);
            }
        });
        ExecutionContextImpl context = new ExecutionContextImpl((ResourceManager)new WorkspaceResourceManager(Activator.getExtXptModelManager().findProject((IResource)this.project)), ts, null);
        return new ExtXptFacade(this.project, (ExecutionContext)context);
    }

    private List<EPackage> findMetaModelPackages() {
        this.createModel();
        ArrayList<EPackage> packs = new ArrayList<EPackage>();
        EcoreUtil.resolveAll((ResourceSet)this.getEditingDomain().getResourceSet());
        EList resources = this.getEditingDomain().getResourceSet().getResources();
        if (resources != null) {
            for (Resource res : resources) {
                EObject rootObject;
                TreeIterator allContents = res.getAllContents();
                if (!allContents.hasNext() || !((rootObject = (EObject)allContents.next()) instanceof EPackage)) continue;
                packs.add((EPackage)rootObject);
            }
        }
        return packs;
    }

    public IFile getFile() {
        return (IFile)this.getEditorInput().getAdapter(IFile.class);
    }

    public ExtendedReflectiveItemProviderAdapterFactory.ExtendedReflectiveItemProvider getExtendedReflectiveItemProvider() {
        return this.extendedReflectiveItemProvider;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                EEditor.this.currentViewer.refresh();
            }
        });
    }

    public ExtXptFacade getExtXptFacade() {
        return this.facade;
    }

    public static int formularOrientation() {
        IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        int pref = store.getInt("eeditor.orientation");
        if (pref != 512 && pref != 256) {
            return 512;
        }
        return pref;
    }
}

