/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import org.eclipse.jet.core.parser.ast.Comment;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETDirective;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.core.parser.ast.XMLBodyElementEnd;
import org.eclipse.jet.core.parser.ast.XMLEmptyElement;
import org.eclipse.jet.internal.core.parser.LineInfo;

public class TextTrimmingVisitor
extends JETASTVisitor {
    private void checkAndStrip(JETASTElement element) {
        if (element.removeLineWhenOtherwiseEmpty()) {
            JETASTElement prev = element.getPrevElement();
            JETASTElement next = element.getNextElement();
            if (this.endsWithEmtpyLine(prev) && this.startsWithEmptyLine(next)) {
                this.trimLastLine(prev);
                this.trimFirstLine(next);
            }
        }
    }

    private void trimLastLine(JETASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            text.setTrimLastLine(true);
        }
    }

    private void trimFirstLine(JETASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            text.setTrimFirstLine(true);
        }
    }

    private boolean startsWithEmptyLine(JETASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            LineInfo[] lines = text.getLines();
            if (lines.length > 0 && lines[0].hasDelimiter()) {
                LineInfo line = lines[0];
                if (new String(text.getRawText(), line.getStart(), line.getEnd() - line.getStart()).trim().length() == 0) {
                    return true;
                }
            }
        } else if (element == null) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean endsWithEmtpyLine(JETASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            LineInfo[] lines = text.getLines();
            if (lines.length <= 0) return false;
            LineInfo line = lines[lines.length - 1];
            if (line.hasDelimiter()) {
                return true;
            }
            if (lines.length <= 1 || new String(text.getRawText(), line.getStart(), line.getEnd() - line.getStart()).trim().length() != 0) return false;
            return true;
        }
        if (element != null) return false;
        return true;
    }

    public boolean visit(JavaDeclaration declaration) {
        this.checkAndStrip(declaration);
        return true;
    }

    public boolean visit(JETDirective directive) {
        this.checkAndStrip(directive);
        return true;
    }

    public boolean visit(JavaExpression expression) {
        this.checkAndStrip(expression);
        return true;
    }

    public boolean visit(JavaScriptlet scriptlet) {
        this.checkAndStrip(scriptlet);
        return true;
    }

    public boolean visit(XMLEmptyElement xmlEmptyElement) {
        this.checkAndStrip(xmlEmptyElement);
        return true;
    }

    public boolean visit(XMLBodyElement xmlBodyElement) {
        this.checkAndStrip(xmlBodyElement);
        return true;
    }

    public boolean visit(XMLBodyElementEnd xmlBodyElementEnd) {
        this.checkAndStrip(xmlBodyElementEnd);
        return true;
    }

    public boolean visit(Comment comment) {
        this.checkAndStrip(comment);
        return true;
    }
}

