/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.expressions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.internal.core.expressions.IEmbeddedLanguage;

public class EmbeddedExpressionLanguageManager {
    private static EmbeddedExpressionLanguageManager instance;
    private final Map languageRegistry = Collections.synchronizedMap(new HashMap());

    private EmbeddedExpressionLanguageManager() {
    }

    public void addLanguage(String language, IEmbeddedLanguage embeddedLanguage) {
        if (language == null || embeddedLanguage == null) {
            throw new NullPointerException();
        }
        this.languageRegistry.put(language, embeddedLanguage);
    }

    public Map getLanguages() {
        return new HashMap(this.languageRegistry);
    }

    public static synchronized EmbeddedExpressionLanguageManager getInstance() {
        if (instance == null) {
            instance = new EmbeddedExpressionLanguageManager();
        }
        return instance;
    }

    public IEmbeddedLanguage getLanguage(String language) {
        return (IEmbeddedLanguage)this.languageRegistry.get(language);
    }
}

