/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.rules;

import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.partition.JETDocumentPartitionScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public abstract class ASTElementScannerRule
implements IPredicateRule {
    private JETTextEditor editor;
    private IToken successToken;

    public ASTElementScannerRule(JETTextEditor editor, IToken successToken) {
        this.editor = editor;
        this.successToken = successToken;
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        JETDocumentPartitionScanner jetScanner = (JETDocumentPartitionScanner)scanner;
        int offset = jetScanner.getNextCharacterOffset();
        JETASTElement element = this.editor.getASTElement(offset);
        if (element != null && this.isAcceptedElement(element)) {
            int length = element.getEnd() - offset;
            int i = 0;
            while (i < length) {
                scanner.read();
                ++i;
            }
            return this.successToken;
        }
        return Token.UNDEFINED;
    }

    protected abstract boolean isAcceptedElement(JETASTElement var1);
}

