/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.ArrayList;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.exceptions.MissingRequiredAttributeException;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractFunctionTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;

public class ReplaceStringsTag
extends AbstractFunctionTag {
    private String _replace = null;
    private String _with = null;

    public String doFunction(TagInfo tagInfo, JET2Context context, String bodyContent) throws JET2TagException {
        this._replace = this.getAttribute("replace");
        if (this._replace == null) {
            throw new MissingRequiredAttributeException("replace");
        }
        this._with = this.getAttribute("with");
        if (this._with == null) {
            throw new MissingRequiredAttributeException("with");
        }
        String[] replace = this.getStrings(this._replace);
        String[] with = this.getStrings(this._with);
        String buffer = this.replaceString(bodyContent, replace, with);
        return buffer;
    }

    public String[] getStrings(String buffer) throws JET2TagException {
        ArrayList<String> v = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int offset = 0;
        while (offset < buffer.length()) {
            char c = buffer.charAt(offset);
            if (c == ',') {
                v.add(sb.toString());
                sb = new StringBuffer();
                ++offset;
                continue;
            }
            if (c == '\\') {
                try {
                    c = buffer.charAt(offset + 1);
                    if (c == 'r') {
                        sb.append("\r");
                        offset += 2;
                        continue;
                    }
                    if (c == 'n') {
                        sb.append("\n");
                        offset += 2;
                        continue;
                    }
                    if (c == 't') {
                        sb.append("\t");
                        offset += 2;
                        continue;
                    }
                    if (c == '\\') {
                        sb.append("\\");
                        offset += 2;
                        continue;
                    }
                    if (c == ',') {
                        sb.append(",");
                        offset += 2;
                        continue;
                    }
                    if (c == '&') {
                        if (buffer.substring(offset + 1).startsWith("&lt;")) {
                            sb.append("<");
                            offset += 5;
                            continue;
                        }
                        if (buffer.substring(offset + 1).startsWith("&gt;")) {
                            sb.append(">");
                            offset += 5;
                            continue;
                        }
                        if (buffer.substring(offset + 1).startsWith("&amp;")) {
                            sb.append("&");
                            offset += 6;
                            continue;
                        }
                        if (buffer.substring(offset + 1).startsWith("&apos;")) {
                            sb.append("'");
                            offset += 7;
                            continue;
                        }
                        if (buffer.substring(offset + 1).startsWith("&quot;")) {
                            sb.append("\"");
                            offset += 7;
                            continue;
                        }
                        sb.append("\\&");
                        offset += 2;
                        continue;
                    }
                    sb.append("\\");
                    ++offset;
                    continue;
                }
                catch (Exception exception) {
                    throw new JET2TagException(String.valueOf(JET2Messages.ReplaceStringsTag_BadList) + buffer);
                }
            }
            sb.append(c);
            ++offset;
        }
        v.add(sb.toString());
        String[] result = v.toArray(new String[v.size()]);
        return result;
    }

    private String replaceString(String buffer, String[] replace, String[] with) throws JET2TagException {
        if (replace.length != with.length) {
            throw new JET2TagException(JET2Messages.ReplaceStringsTag_ListsNotSameLength);
        }
        int i = 0;
        while (i < replace.length) {
            if (replace[i].length() == 0) {
                throw new JET2TagException(JET2Messages.ReplaceStringsTag_EmptyList);
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int offset = 0;
        while (offset < buffer.length()) {
            boolean match = false;
            int i2 = 0;
            i2 = 0;
            while (i2 < replace.length & !match) {
                if (buffer.substring(offset).startsWith(replace[i2])) {
                    match = true;
                    sb.append(with[i2]);
                    offset += replace[i2].length();
                }
                ++i2;
            }
            if (match) continue;
            sb.append(buffer.charAt(offset));
            ++offset;
        }
        return sb.toString();
    }
}

