/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;

public class WsCopyBinaryFileAction
extends AbstractWorkspaceAction
implements IWorkspaceAction {
    private final IFile file;
    private final boolean replace;
    private final byte[] contents;
    private final JET2Context context;

    public WsCopyBinaryFileAction(JET2Context context, String templatePath, TagInfo tagInfo, byte[] contents, IFile targetFile, boolean replaceExisting) {
        super(tagInfo, templatePath);
        this.context = context;
        this.contents = contents;
        this.file = targetFile;
        this.replace = replaceExisting;
    }

    public IResource getResource() {
        return this.file;
    }

    public boolean requiresValidateEdit() {
        return this.replace && this.file.exists() && this.file.isReadOnly();
    }

    public void performAction(IProgressMonitor monitor) throws JET2TagException {
        ActionsUtil.writeBinaryFile(this.file, this.replace, this.contents, monitor);
        String fileMessage = MessageFormat.format(JET2Messages.WsCopyBinaryFileAction_WritingFile, this.file.getFullPath().toString());
        RuntimeLoggerContextExtender.log(this.context, fileMessage, this.getTagInfo(), this.getTemplatePath(), 3);
    }
}

