/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.taglib.DocumentHelper;
import org.eclipse.jet.internal.taglib.control.DeepIterateEntry;
import org.eclipse.jet.internal.taglib.control.DeepIteratorStrategyBuilder;
import org.eclipse.jet.internal.taglib.control.IDeepIterateStrategy;
import org.eclipse.jet.taglib.AbstractIteratingTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeepIterateTag
extends AbstractIteratingTag {
    private static final String INSERTION_POINT_CATEGORY;
    private String tagName;
    private String var;
    private String varStatus;
    private Iterator iterator;
    private Object savedVarValue;
    private Object savedVarStatusValue;
    private String indent;
    private DeepIterateEntry currentEntry;
    private DeepContentPositionTracker deepContentPositionTracker;
    private BufferedJET2Writer workingOutput;
    private IDeepIterateStrategy strategy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.internal.taglib.control.DeepIterateTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INSERTION_POINT_CATEGORY = String.valueOf(clazz.getName()) + ".INSERT_POSITION";
    }

    public void doInitializeLoop(TagInfo td, JET2Context context) throws JET2TagException {
        this.tagName = td.getTagName();
        this.var = this.getAttribute("var");
        this.varStatus = this.getAttribute("varStatus");
        this.indent = this.getAttribute("indent");
        this.savedVarValue = this.saveVariable(context, this.var);
        this.savedVarStatusValue = this.saveVariable(context, this.varStatus);
        DeepIteratorStrategyBuilder builder = new DeepIteratorStrategyBuilder(context, this.tagName, this.getAttribute("select")).var(this.var).traversal(this.getAttribute("traversal")).varStatus(this.varStatus).allowDuplicates(td.hasAttribute("allowDuplicates") ? Boolean.getBoolean(td.getAttribute("allowDuplicates")) : true).filter(this.getAttribute("filter"));
        String contextSelect = this.getAttribute("initialContext");
        if (contextSelect != null) {
            XPathContextExtender xpc = XPathContextExtender.getInstance(context);
            builder.contextObject(xpc.resolveSingle(contextSelect));
        }
        this.strategy = builder.build();
        Collection result = this.strategy.search();
        if (this.strategy.supportsDeepContent()) {
            this.deepContentPositionTracker = new DeepContentPositionTracker();
        }
        this.initWorkingOutput();
        this.iterator = result.iterator();
    }

    private Object saveVariable(JET2Context context, String varName) throws JET2TagException {
        Object savedValue = null;
        if (varName != null) {
            savedValue = context.hasVariable(varName) ? context.getVariable(varName) : null;
        }
        return savedValue;
    }

    private void initWorkingOutput() {
        this.workingOutput = (BufferedJET2Writer)this.getOut().newNestedContentWriter();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument doc = (IDocument)this.workingOutput.getAdapter((Class)clazz);
        DocumentHelper.installPositionCategory(doc, INSERTION_POINT_CATEGORY);
    }

    public boolean doEvalLoopCondition(TagInfo td, JET2Context context) throws JET2TagException {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.restoreVariable(context, this.var, this.savedVarValue);
            this.restoreVariable(context, this.varStatus, this.savedVarStatusValue);
        }
        if (!hasNext) {
            this.flushWorkingOutput();
        }
        return hasNext;
    }

    private void restoreVariable(JET2Context context, String varName, Object savedValue) throws JET2TagException {
        if (varName != null) {
            if (savedValue != null) {
                context.setVariable(varName, savedValue);
            } else {
                context.removeVariable(varName);
            }
        }
    }

    private void flushWorkingOutput() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument doc = (IDocument)this.workingOutput.getAdapter((Class)clazz);
        try {
            doc.removePositionCategory(INSERTION_POINT_CATEGORY);
        }
        catch (BadPositionCategoryException e) {
            throw new RuntimeException("Internal Error: Position category has not been added: " + INSERTION_POINT_CATEGORY, e);
        }
        this.getOut().write((JET2Writer)this.workingOutput);
    }

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        super.doBeforeBody(td, context, out);
        this.currentEntry = (DeepIterateEntry)this.iterator.next();
        if (this.deepContentPositionTracker != null) {
            this.deepContentPositionTracker.initDepth(this.currentEntry.getDepth());
        }
        XPathContextExtender xpc = XPathContextExtender.getInstance(context);
        xpc.pushXPathContextObject(this.currentEntry.getObject());
        this.setVariable(context, this.var, this.currentEntry.getObject());
        if (this.varStatus != null) {
            LoopStatus status = new LoopStatus(this.currentEntry.getDepth(), this.currentEntry.isLeaf());
            this.setVariable(context, this.varStatus, status.asInspectableObject());
        }
    }

    private void setVariable(JET2Context context, String varName, Object varValue) throws JET2TagException {
        if (varName != null) {
            context.setVariable(varName, varValue);
        }
    }

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        super.doAfterBody(td, context, out);
        XPathContextExtender xpc = XPathContextExtender.getInstance(context);
        xpc.popXPathContextObject();
    }

    public void setBodyContent(JET2Writer bodyContent) {
        Position insertPosition;
        if (this.indent != null) {
            DocumentHelper.indent((BufferedJET2Writer)bodyContent, this.currentEntry.getDepth() - 1, this.indent);
        }
        Position position = insertPosition = this.deepContentPositionTracker != null ? this.deepContentPositionTracker.getInsertPosition() : null;
        if (insertPosition != null) {
            this.replaceContent(this.workingOutput, (DocumentHelper.InsertAfterEmptyPosition)insertPosition, (BufferedJET2Writer)bodyContent);
        } else {
            this.workingOutput.write(bodyContent);
        }
    }

    private void replaceContent(BufferedJET2Writer targetWriter, DocumentHelper.InsertAfterEmptyPosition insertPosition, BufferedJET2Writer sourceWriter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument targetDocument = (IDocument)targetWriter.getAdapter((Class)clazz);
        int insertionOffset = insertPosition.offset;
        insertPosition.setEnableInsertBefore(true);
        targetWriter.replaceContent(insertionOffset, insertPosition.length, sourceWriter.getContent());
        insertPosition.setEnableInsertBefore(false);
        try {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IDocument sourceDocument = (IDocument)sourceWriter.getAdapter((Class)clazz2);
            String[] categories = sourceDocument.getPositionCategories();
            int i = 0;
            while (i < categories.length) {
                DocumentHelper.installPositionCategory(targetDocument, categories[i]);
                Position[] positions = sourceDocument.getPositions(categories[i]);
                int j = 0;
                while (j < positions.length) {
                    sourceDocument.removePosition(categories[i], positions[j]);
                    positions[j].setOffset(positions[j].getOffset() + insertionOffset);
                    targetDocument.addPosition(categories[i], positions[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
        catch (BadLocationException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
    }

    public void markContentInsertionPoint(BufferedJET2Writer out) throws JET2TagException {
        this.strategy.checkDeepContentAllowed();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument document = (IDocument)out.getAdapter((Class)clazz);
        DocumentHelper.installPositionCategory(document, INSERTION_POINT_CATEGORY);
        DocumentHelper.InsertAfterEmptyPosition position = new DocumentHelper.InsertAfterEmptyPosition(document.getLength());
        try {
            document.addPosition(INSERTION_POINT_CATEGORY, (Position)position);
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Internal Error: Unexpected invalid position: " + position, e);
        }
        catch (BadPositionCategoryException e) {
            throw new RuntimeException("Internal Error: Position category has not been added: " + INSERTION_POINT_CATEGORY, e);
        }
        this.deepContentPositionTracker.setPosition(position);
    }

    private static final class DeepContentPositionTracker {
        private List insertPositions = new ArrayList();

        public DeepContentPositionTracker() {
            this.insertPositions.add(null);
        }

        final Position getInsertPosition() {
            int size = this.insertPositions.size();
            if (size < 2) {
                throw new IllegalStateException("size = " + size);
            }
            return (Position)this.insertPositions.get(size - 2);
        }

        final void initDepth(int newDepth) {
            int oldDepth = this.insertPositions.size() - 1;
            if (newDepth < 1 || newDepth > oldDepth + 1) {
                throw new IllegalArgumentException("newdepth = " + newDepth + ", oldDepth = " + oldDepth);
            }
            int i = oldDepth;
            while (i >= newDepth) {
                this.insertPositions.remove(i);
                --i;
            }
            this.insertPositions.add(null);
        }

        final void setPosition(Position position) {
            this.insertPositions.set(this.insertPositions.size() - 1, position);
        }
    }

    static class LoopStatus
    extends DeepIterateTag {
        private final int depth;
        private boolean leaf;

        public LoopStatus(int depth) {
            this.depth = depth;
        }

        public LoopStatus(int depth, boolean leaf) {
            this.depth = depth;
            this.leaf = leaf;
        }

        final int getDepth() {
            return this.depth;
        }

        public void setLeaf(boolean leaf) {
            this.leaf = leaf;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public Object asInspectableObject() {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element status = document.createElement("status");
                document.appendChild(status);
                status.setAttribute("depth", Integer.toString(this.depth));
                if (this.leaf) {
                    status.setAttribute("isLeaf", "true");
                }
                return status;
            }
            catch (DOMException e) {
                throw new RuntimeException("Internal Error: An XML name is unexpectedly invalid", e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Internal Error: DocumentBuilder could not be created.", e);
            }
            catch (FactoryConfigurationError e) {
                throw new RuntimeException("Internal Error: DocumentBuilderFactory could not be created.", e);
            }
        }
    }
}

