/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.taglib.format.MessageTag;
import org.eclipse.jet.internal.taglib.format.Messages;
import org.eclipse.jet.taglib.AbstractContainerTag;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.osgi.util.NLS;

public class ParamTag
extends AbstractContainerTag {
    private String value;

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        this.value = this.getAttribute("value");
    }

    public void setBodyContent(JET2Writer bodyContent) {
        if (this.value == null && bodyContent instanceof BufferedJET2Writer) {
            this.value = ((BufferedJET2Writer)bodyContent).getContent();
        }
    }

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        CustomTag parent = this.getParent();
        if (!(parent instanceof MessageTag)) {
            throw new JET2TagException(NLS.bind((String)Messages.ParamTag_MustBeContainedByMessageTag, (Object)this.getMessageTagName(td)));
        }
        if (this.value == null) {
            throw new JET2TagException(Messages.ParamTag_NoValueSpecified);
        }
        MessageTag messageTag = (MessageTag)parent;
        messageTag.addParam(this.value);
    }

    private String getMessageTagName(TagInfo td) {
        StringBuffer name = new StringBuffer(20);
        name.append('<');
        String paramTagName = td.getTagName();
        int colonPos = paramTagName.indexOf(58);
        if (colonPos > 0) {
            name.append(paramTagName.substring(0, colonPos));
            name.append(':');
        }
        name.append("message");
        name.append('>');
        return name.toString();
    }
}

