/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.contentassist;

import java.util.HashMap;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.internal.editor.JETEditorHelper;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.contentassist.AbstractJETAssistProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JETJavaDeclarationAssistProcessor
extends AbstractJETAssistProcessor {
    private char[] completionProposalAutoActivationCharacters;

    public JETJavaDeclarationAssistProcessor(JETTextEditor editor) {
        super(editor);
        this.completionProposalAutoActivationCharacters = editor.getEditorPreferenceStore().getString("content_assist_autoactivation_triggers_java").toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        JETCompilationUnit cu = this.editor.requestCompilationUnit();
        JavaDeclaration declaration = (JavaDeclaration)this.editor.getASTElement(offset);
        int javaContentStart = declaration.getJavaStart();
        IJavaProject javaProject = this.editor.getJavaProject();
        if (javaProject != null) {
            HashMap mappingPositions = new HashMap();
            String javaSource = this.editor.compilationHelper().getJavaCode(cu, mappingPositions);
            int javaStartOffset = ((Position)mappingPositions.get((Object)declaration)).offset;
            int javaOffset = javaStartOffset + (offset - javaContentStart);
            JETEditorHelper.checkOffsetPositions(javaSource, viewer.getDocument().get(), offset, javaOffset, 15);
            IJavaCompletionProposal[] javaCompletionProposals = JETEditorHelper.getJavaCompletionProposal(javaProject, cu, javaSource, viewer, javaOffset);
            JETEditorHelper.adjustResults(javaCompletionProposals, offset);
            return javaCompletionProposals;
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

