/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.taglib.workspace.WsCopyBinaryFileAction;
import org.eclipse.jet.internal.taglib.workspace.WsCopyTextFileAction;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction2;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;
import org.eclipse.jet.transform.TransformContextExtender;

public class CopyFileTag
extends AbstractEmptyTag {
    public void doAction(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        AbstractWorkspaceAction2 action;
        WorkspaceContextExtender wsExtender;
        IFile file;
        String url = this.getAttribute("src");
        Path path = new Path(this.getAttribute("target"));
        String urlContext = this.getAttribute("srcContext");
        String binary = this.getAttribute("binary");
        String replace = this.getAttribute("replace");
        String srcEncoding = this.getAttribute("srcEncoding");
        String targetEncoding = this.getAttribute("targetEncoding");
        boolean textCopy = true;
        if (binary != null && "true".equalsIgnoreCase(binary)) {
            textCopy = false;
        }
        boolean replaceExisting = true;
        if (replace != null && "false".equalsIgnoreCase(replace)) {
            replaceExisting = false;
        }
        if ((file = this.getTargetFile((IPath)path, wsExtender = WorkspaceContextExtender.getInstance(context))).exists() && !replaceExisting) {
            return;
        }
        URL sourceURL = this.getSourceURL(url, urlContext, context);
        if (textCopy) {
            String sourceFileContents = ActionsUtil.readTextFile(sourceURL, srcEncoding);
            action = new WsCopyTextFileAction(context.getTemplatePath(), td, sourceFileContents, file, replaceExisting, targetEncoding);
        } else {
            byte[] contents = ActionsUtil.readBinaryFile(sourceURL);
            action = new WsCopyBinaryFileAction(context.getTemplatePath(), td, contents, file, replaceExisting);
        }
        wsExtender.addAction(action);
    }

    private URL getSourceURL(String url, String urlContext, JET2Context context) throws JET2TagException {
        URL sourceURL;
        TransformContextExtender tce = TransformContextExtender.getInstance(context);
        URL baseURL = tce.getBaseURL(urlContext);
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        try {
            sourceURL = new URL(baseURL, url);
        }
        catch (MalformedURLException e) {
            throw new JET2TagException((Throwable)e);
        }
        return sourceURL;
    }

    private IFile getTargetFile(IPath path, WorkspaceContextExtender wsExtender) throws JET2TagException {
        IFile file;
        if (path.isAbsolute() || !wsExtender.existsContainer()) {
            try {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            catch (IllegalArgumentException e) {
                throw new JET2TagException(e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            file = wsExtender.getContainer().getFile(path);
        }
        return file;
    }
}

