/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.extensionpoints.IPluginChangeListener;
import org.eclipse.jet.internal.runtime.JETBundleManager;
import org.eclipse.jet.internal.runtime.JETBundleManifest;
import org.eclipse.jet.internal.runtime.NotABundleException;

public class PluginProjectMonitor
implements IResourceChangeListener {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/pluginProjectMonitor")) != false;
    private final Set listeners = Collections.synchronizedSet(new HashSet());

    public static boolean isPluginProject(IProject project) {
        if (project.isOpen()) {
            return PluginProjectMonitor.hasBundleManifest(project) || PluginProjectMonitor.hasPluginManifest(project);
        }
        return false;
    }

    public static boolean hasBundleManifest(IProject project) {
        return project.exists((IPath)new Path("META-INF/MANIFEST.MF"));
    }

    public static boolean hasPluginManifest(IProject project) {
        return project.exists((IPath)new Path("plugin.xml"));
    }

    public static boolean isJETPluginProject(IProject project) {
        boolean result = false;
        try {
            result = project.isOpen() && project.hasNature("org.eclipse.jet.jet2Nature");
        }
        catch (CoreException coreException) {}
        return result;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                this.handleProjectChange((IProject)event.getResource());
                break;
            }
            case 1: {
                this.handleWorkspaceChange(event.getDelta());
            }
        }
    }

    private void handleWorkspaceChange(IResourceDelta delta) {
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta childDelta) throws CoreException {
                    switch (childDelta.getResource().getType()) {
                        case 8: {
                            return true;
                        }
                        case 4: {
                            IProject project = (IProject)childDelta.getResource();
                            if (PluginProjectMonitor.isPluginProject(project)) {
                                IResourceDelta manifestDelta = childDelta.findMember((IPath)new Path("META-INF/MANIFEST.MF"));
                                IResourceDelta pluginXML = childDelta.findMember((IPath)new Path("plugin.xml"));
                                if (manifestDelta != null || pluginXML != null) {
                                    PluginProjectMonitor.this.updateProject(project);
                                }
                                return true;
                            }
                            return false;
                        }
                        case 2: {
                            IFolder folder = (IFolder)childDelta.getResource();
                            return folder.getProjectRelativePath().equals((Object)new Path("META-INF/MANIFEST.MF").removeLastSegments(1));
                        }
                    }
                    return false;
                }
            });
        }
        catch (CoreException e) {
            InternalJET2Platform.logError("Exception caught in \"should never happen\" catch clause", (Exception)((Object)e));
        }
    }

    private void handleProjectChange(IProject project) {
        try {
            if (project.isOpen() && project.exists() && project.hasNature("org.eclipse.jet.jet2Nature")) {
                this.removeJETProject(project);
            }
        }
        catch (CoreException e) {
            InternalJET2Platform.logError("Exception caught in \"should never happen\" catch clause", (Exception)((Object)e));
        }
    }

    private void removeJETProject(IProject project) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IPluginChangeListener listener = (IPluginChangeListener)i.next();
            listener.projectRemoved(project);
        }
    }

    public void startup() {
        if (DEBUG) {
            System.out.println("PluginProjectMonitor.startup()");
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (PluginProjectMonitor.isPluginProject(project)) {
                this.updateProject(project);
            }
            ++i;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void updateProject(IProject project) {
        if (DEBUG) {
            System.out.println("PluginProjectMonitor.updateProject(" + project + ")");
        }
        try {
            URL projectURL = new URL("platform:/resource/" + project.getName() + "/");
            JETBundleManifest manifest = JETBundleManager.loadManifest(projectURL);
            Object pluginDocumentRoot = null;
            if (PluginProjectMonitor.hasPluginManifest(project)) {
                if (DEBUG) {
                    System.out.println("  has plugin.xml");
                }
                URL extensionsURL = new URL(projectURL, "plugin.xml");
                pluginDocumentRoot = JETActivatorWrapper.INSTANCE.getLoaderManager().getLoader(extensionsURL.toExternalForm(), "org.eclipse.jet.xml", "xml").load(extensionsURL);
            }
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                IPluginChangeListener listener = (IPluginChangeListener)i.next();
                listener.projectUpdated(project, manifest, pluginDocumentRoot);
            }
        }
        catch (MalformedURLException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        catch (CoreJETException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        catch (NotABundleException notABundleException) {}
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.listeners.clear();
    }

    public void addPluginProjectListener(IPluginChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public void removePluginProjectListener(IPluginChangeListener listener) {
        this.listeners.remove(listener);
    }
}

