/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.designer.languages.java.reverse.exception.ImportNotFoundException;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.UmlUtils;

public class ImportedTypeCatalog {
    public static final String JAVA_LIBRARY_URI = "pathmap://PapyrusJava_LIBRARIES/JavaLibrary.uml";
    private Map<String, List<String>> map = new HashMap<String, List<String>>();
    private List<List<String>> starImports;
    public String[] defaultMappingNames = new String[]{"String", "java.lang.String", "Class", "java.lang.Class", "Object", "java.lang.Object", "Exception", "java.lang.Exception", "NullPointerException", "java.lang.NullPointerException", "Integer", "primitivetype.Integer", "Boolean", "primitivetype.Boolean", "Long", "primitivetype.Long", "Char", "primitivetype.Char", "Byte", "primitivetype.Byte", "Float", "primitivetype.Float", "Double", "primitivetype.Double", "Short", "primitivetype.Short", "Runnable", "java.lang.Runnable", "Throwable", "java.lang.Throwable", "Thread", "java.lang.Thread"};

    public ImportedTypeCatalog() {
        this.setDefaultMapping(this.defaultMappingNames);
    }

    private void setDefaultMapping(String[] defaultMappingNames) {
        int i = 0;
        while (i < defaultMappingNames.length) {
            this.map.put(defaultMappingNames[i], UmlUtils.toQualifiedName(defaultMappingNames[i + 1]));
            System.out.println("setDefaultMapping().add(" + defaultMappingNames[i] + ", " + UmlUtils.toQualifiedName(defaultMappingNames[i + 1]) + ")");
            i += 2;
        }
    }

    public List<String> getQualifiedName(String shortName) {
        List<String> res = this.map.get(shortName);
        if (res == null) {
            res = UmlUtils.toQualifiedName(shortName);
        }
        return res;
    }

    public List<String> getImportQualifiedNameChecked(String shortName) throws ImportNotFoundException {
        List<String> res = this.map.get(shortName);
        if (res == null) {
            throw new ImportNotFoundException(shortName);
        }
        return res;
    }

    private List<String> lookupQualifiedName(String shortName) {
        List<String> res = this.map.get(shortName);
        return res;
    }

    public List<String> getQualifiedName(List<String> possiblyQualifiedName) {
        if (possiblyQualifiedName.size() == 1) {
            List<String> res = this.lookupQualifiedName(possiblyQualifiedName.get(0));
            if (res == null) {
                res = possiblyQualifiedName;
            }
            return res;
        }
        return possiblyQualifiedName;
    }

    public boolean isImportedType(List<String> qualifiedName) {
        String lastName = qualifiedName.get(qualifiedName.size() - 1);
        List<String> found = this.map.get(lastName);
        return found != null && found.equals(qualifiedName);
    }

    public void addImport(List<String> qualifiedName) {
        String lastName = qualifiedName.get(qualifiedName.size() - 1);
        System.out.println("ImportedCatalog.add(" + qualifiedName + ")");
        if ("*".equals(lastName)) {
            this.addStarImport(qualifiedName.subList(0, qualifiedName.size() - 1));
        } else {
            this.map.put(lastName, qualifiedName);
        }
    }

    public void addStarImport(List<String> qualifiedName) {
        if (this.starImports == null) {
            this.starImports = new ArrayList<List<String>>();
        }
        this.starImports.add(qualifiedName);
    }

    public void clear() {
        this.map.clear();
        this.setDefaultMapping(this.defaultMappingNames);
    }

    public List<List<String>> getStarImports() {
        if (this.starImports != null) {
            return this.starImports;
        }
        return Collections.emptyList();
    }
}

