/**
 * Copyright (c) 2016 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Ansgar Radermacher - Initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.idl.codegen;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class ComponentCCD {
  public static CharSequence generateCCD(final org.eclipse.uml2.uml.Class x) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("<!-- Generated CCD for component ");
    String _name = x.getName();
    _builder.append(_name);
    _builder.append(" -->");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("<ComponentInterfaceDescription>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<label>");
    String _name_1 = x.getName();
    _builder.append(_name_1, "\t");
    _builder.append("</label>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<UUID>");
    String _name_2 = x.getName();
    _builder.append(_name_2, "\t");
    _builder.append("</UUID>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<specificType>");
    String _name_3 = x.getName();
    _builder.append(_name_3, "\t");
    _builder.append("</specificType>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<supportedType></supportedType>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<idlFile>");
    String _name_4 = x.getName();
    _builder.append(_name_4, "\t");
    _builder.append(".idl3</idlFile>");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("<configProperty></configProperty>");
    _builder.newLine();
    _builder.newLine();
    {
      EList<Port> _ownedPorts = x.getOwnedPorts();
      for(final Port port : _ownedPorts) {
        CharSequence _generatePort = ComponentCCD.generatePort(port);
        _builder.append(_generatePort);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("</ComponentInterfaceDescription>");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generate a CCD definition for a port. Assumes that port either provides or requires
   * a single interface (strong restriction)
   */
  public static CharSequence generatePort(final Port port) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<port>");
    _builder.newLine();
    {
      EList<Interface> _provideds = port.getProvideds();
      for(final Interface forVar : _provideds) {
        _builder.append("<name>");
        String _name = port.getName();
        _builder.append(_name);
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("<specificType>");
        String _name_1 = forVar.getName();
        _builder.append(_name_1);
        _builder.append("</specificType>");
        _builder.newLineIfNotEmpty();
        _builder.append("<supportedType></supportedType>");
        _builder.newLine();
        _builder.append("<provider>true</provider>");
        _builder.newLine();
        _builder.append("<exclusiveProvider>false</exclusiveProvider>");
        _builder.newLine();
        _builder.append("<exclusiveUser>false</exclusiveUser>");
        _builder.newLine();
        _builder.append("<optional>true</optional>");
        _builder.newLine();
        _builder.append("<kind>Facet</kind>");
        _builder.newLine();
      }
    }
    {
      EList<Interface> _requireds = port.getRequireds();
      for(final Interface forVar_1 : _requireds) {
        _builder.append("<name>");
        String _name_2 = port.getName();
        _builder.append(_name_2);
        _builder.append("</name>");
        _builder.newLineIfNotEmpty();
        _builder.append("<specificType>");
        String _name_3 = forVar_1.getName();
        _builder.append(_name_3);
        _builder.append("</specificType>");
        _builder.newLineIfNotEmpty();
        _builder.append("<supportedType></supportedType>");
        _builder.newLine();
        _builder.append("<provider>false</provider>");
        _builder.newLine();
        _builder.append("<exclusiveProvider>false</exclusiveProvider>");
        _builder.newLine();
        _builder.append("<exclusiveUser>false</exclusiveUser>");
        _builder.newLine();
        _builder.append("<optional>true</optional>");
        _builder.newLine();
        _builder.append("<kind>Receptacle</kind>");
        _builder.newLine();
      }
    }
    _builder.append("</port>");
    _builder.newLine();
    return _builder;
  }
}
