/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.generatorconfiguration.operations;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.internal.Activator;
import org.osgi.framework.Bundle;

public class GeneratorConfigurationOperations {
    private static final String SLASH = "/";
    private static final String UNDERSCORE = "_";

    public static final URI getDocumentStructureFileEcoreURI(IDocumentStructureGeneratorConfiguration generatorConfiguration, String fileExtension, String optionalVersionSuffix) {
        URI uri;
        String scheme;
        String folderName = generatorConfiguration.getStructureFolder();
        StringBuilder documentNameBuilder = new StringBuilder(generatorConfiguration.getDocumentName());
        if (optionalVersionSuffix != null && !optionalVersionSuffix.isEmpty()) {
            documentNameBuilder.append(UNDERSCORE);
            documentNameBuilder.append(optionalVersionSuffix);
        }
        if ((scheme = (uri = URI.createURI((String)folderName)).scheme()) != null && !scheme.isEmpty()) {
            throw new UnsupportedOperationException("A such path for DocumentStructure is not supported: " + uri);
        }
        if (!uri.isPlatform()) {
            String projectName = generatorConfiguration.eResource().getURI().segment(1);
            uri = URI.createPlatformResourceURI((String)projectName, (boolean)true);
            String[] stringArray = folderName.split(SLASH);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String current = stringArray[n2];
                uri = uri.appendSegment(current);
                ++n2;
            }
        }
        if (uri.isPlatform()) {
            if (uri.isPlatformPlugin()) {
                Activator.log.warn(NLS.bind((String)"The path {0} must not be a platform path", (Object)uri.toString()));
                return null;
            }
            return uri.appendSegment(documentNameBuilder.toString()).appendFileExtension(fileExtension);
        }
        return null;
    }

    public static final String getDocumentFileLocalPath(IDocumentGeneratorConfiguration configuration, String fileExtension) {
        String projectName;
        if (configuration.eResource() == null) {
            projectName = null;
        } else {
            if (configuration.eResource().getURI() == null || configuration.eResource().getURI().segmentCount() < 1) {
                throw new UnsupportedOperationException("This method doesn't work with DefaultDocumentGeneratorConfiguration which are not saved in a resource");
            }
            projectName = configuration.eResource().getURI().segment(1);
        }
        return GeneratorConfigurationOperations.buildLocalPath(projectName, configuration.getDocumentFolder(), configuration.getDocumentName(), fileExtension);
    }

    public static final String getImageFileLocalPath(IDocumentStructureGeneratorConfiguration configuration, String imageName, String imageExtension) {
        String imageNameToUse = imageName.replaceAll("\\s+", "");
        if (configuration.eResource() == null || configuration.eResource().getURI() == null || configuration.eResource().getURI().segmentCount() < 1) {
            throw new UnsupportedOperationException("This method doesn't work with DefaultDocumentStructureGeneratorConfiguration which are not saved in a resource");
        }
        String projectName = configuration.eResource().getURI().segment(1);
        return GeneratorConfigurationOperations.buildLocalPath(projectName, configuration.getImageFolder(), imageNameToUse, imageExtension);
    }

    private static final String buildLocalPath(String projectName, String folderPath, String fileName, String fileExtension) {
        URI uri = URI.createURI((String)folderPath);
        String scheme = uri.scheme();
        if (!uri.isPlatform() && scheme != null && !scheme.isEmpty()) {
            URI newURI = URI.createFileURI((String)folderPath);
            newURI = newURI.appendSegment(fileName).appendFileExtension(fileExtension);
            return newURI.toString();
        }
        if (!uri.isPlatform()) {
            uri = folderPath.contains(SLASH) ? URI.createPlatformResourceURI((String)projectName, (boolean)true).appendSegments(folderPath.split(SLASH)) : URI.createPlatformResourceURI((String)projectName, (boolean)true).appendSegment(folderPath);
        }
        if (uri.isPlatform()) {
            if (uri.isPlatformPlugin()) {
                Activator.log.warn(NLS.bind((String)"The path {0} must not be a platform path", (Object)uri.toString()));
                return null;
            }
            uri = uri.appendSegment(fileName).appendFileExtension(fileExtension);
        }
        IPath res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).getLocation();
        return URI.createFileURI((String)res.toPortableString()).toString();
    }

    private static final URI getImageFolderURI(IDocumentStructureGeneratorConfiguration configuration) {
        if (configuration.eResource() == null || configuration.eResource().getURI() == null || configuration.eResource().getURI().segmentCount() < 1) {
            throw new UnsupportedOperationException("This method doesn't work with DefaultDocumentStructureGeneratorConfiguration which are not saved in a resource");
        }
        String projectName = configuration.eResource().getURI().segment(1);
        return GeneratorConfigurationOperations.getImageFolderURI(projectName, configuration.getImageFolder());
    }

    private static final URI getImageFolderURI(String projectName, String folderPath) {
        URI uri = URI.createURI((String)folderPath);
        String scheme = uri.scheme();
        if (!uri.isPlatform() && scheme != null && !scheme.isEmpty()) {
            return URI.createFileURI((String)folderPath);
        }
        if (!uri.isPlatform()) {
            uri = folderPath.contains(SLASH) ? URI.createPlatformResourceURI((String)projectName, (boolean)true).appendSegments(folderPath.split(SLASH)) : URI.createPlatformResourceURI((String)projectName, (boolean)true).appendSegment(folderPath);
        }
        if (uri.isPlatform() && uri.isPlatformPlugin()) {
            Activator.log.warn(NLS.bind((String)"The path {0} must not be a platform path", (Object)uri.toString()));
            return null;
        }
        return uri;
    }

    public static final Collection<String> getWorkspaceProjectToRefresh(IDocumentStructureGeneratorConfiguration configuration) {
        HashSet<String> projectsToRefresh = new HashSet<String>();
        URI uri = GeneratorConfigurationOperations.getDocumentStructureFileEcoreURI(configuration, "dummyExtension", null);
        if (uri != null && uri.isPlatformResource() && uri.segmentCount() > 2) {
            projectsToRefresh.add(uri.segment(1));
        }
        if ((uri = GeneratorConfigurationOperations.getImageFolderURI(configuration)) != null && uri.isPlatformResource() && uri.segmentCount() > 2) {
            projectsToRefresh.add(uri.segment(1));
        }
        return projectsToRefresh;
    }

    public static final String getTemplateFilePathInLocalPath(IDocumentGeneratorConfiguration configuration) {
        return GeneratorConfigurationOperations.getFilePathInLocalPath(configuration, configuration.getTemplateFile());
    }

    public static final String getFilePathInLocalPath(EObject eobject, String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return null;
        }
        URI templateURI = URI.createURI((String)filePath);
        String scheme = templateURI.scheme();
        if (!templateURI.isPlatform() && scheme != null && !scheme.isEmpty()) {
            return URI.createFileURI((String)filePath).toString();
        }
        String res = GeneratorConfigurationOperations.convertToLocalPath(eobject, filePath);
        return URI.createFileURI((String)res).toString();
    }

    private static final String convertToLocalPath(EObject anEobject, String path) {
        URI uri = URI.createURI((String)path, (boolean)true);
        if (!uri.isPlatform()) {
            Assert.isTrue((anEobject.eResource() != null ? 1 : 0) != 0, (String)"The EObject argument must be attached to a Resource");
            URI documentURI = anEobject.eResource().getURI();
            Assert.isTrue((boolean)documentURI.isPlatformResource());
            String projectName = (String)documentURI.segmentsList().get(1);
            URI templateURIPath = URI.createPlatformResourceURI((String)projectName, (boolean)true);
            uri = templateURIPath.appendSegments(uri.segments());
        }
        if (uri.isPlatformPlugin()) {
            List segments = uri.segmentsList();
            String bundleId = (String)segments.get(1);
            StringBuilder pathInBundle = new StringBuilder();
            int i = 2;
            while (i < segments.size()) {
                pathInBundle.append((String)segments.get(i));
                if (i < segments.size() - 1) {
                    pathInBundle.append(SLASH);
                }
                ++i;
            }
            return GeneratorConfigurationOperations.getFileBundlePathToLocalPath(bundleId, pathInBundle.toString());
        }
        if (uri.isPlatformResource()) {
            IPath res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).getLocation();
            return res.toPortableString();
        }
        return null;
    }

    private static final String getFileBundlePathToLocalPath(String bundleId, String filePathInBundle) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            Activator.log.warn(NLS.bind((String)"The bundle {0} doesn't exist", (Object)bundleId));
            return null;
        }
        URL eclipseURL = FileLocator.find((Bundle)bundle, (IPath)new Path(filePathInBundle), null);
        if (eclipseURL == null) {
            Activator.log.warn(NLS.bind((String)"The file {0} doesn't exist in the bundle {1}", (Object)filePathInBundle, (Object)bundleId));
            return null;
        }
        String templateURL = null;
        try {
            URL fileURL = FileLocator.toFileURL((URL)eclipseURL);
            templateURL = fileURL.toString();
            templateURL = templateURL.replaceAll("file:/", "");
        }
        catch (IOException e) {
            Activator.log.error(NLS.bind((String)"The URL {0} can't be converted", (Object)eclipseURL), (Throwable)e);
        }
        return templateURL;
    }
}

