/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.modelexplorer.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.modelexplorer.internal.commands.RenameDocumentTemplateLabelCommand;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.modelexplorer.internal.handlers.AbstractDocumentTemplateCommandHandler;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.modelexplorer.internal.messages.Messages;
import org.eclipse.papyrus.views.modelexplorer.commands.RenameElementCommand;
import org.eclipse.papyrus.views.modelexplorer.util.ModelExplorerEditionUtil;

public class RenameDocumentTemplateHandler
extends AbstractDocumentTemplateCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        List<DocumentTemplate> documents = this.getSelectedDocumentTemplates();
        if (editingDomain != null && documents.size() == 1) {
            DocumentTemplate document = documents.get(0);
            String documentLabel = LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)document, (boolean)true);
            if (documentLabel != null && LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)document)) {
                RenameDocumentTemplateLabelCommand cmd = new RenameDocumentTemplateLabelCommand(editingDomain, "ChangeDocumentTemplateLabelCommand", (EObject)document, documentLabel, Messages.RenameDocumentTemplateHandler_Label_DialogTitle);
                return new GMFtoEMFCommandWrapper((ICommand)cmd);
            }
            String currentName = document.getName();
            if (currentName != null) {
                EAttribute nameFeature = DocumentStructureTemplatePackage.eINSTANCE.getDocumentTemplate_Name();
                return new RenameElementCommand(editingDomain, "RenameDocumentTemplateCommand", (EObject)document, currentName, (EStructuralFeature)nameFeature, Messages.RenameDocumentTemplateHandler_RenameAnExistingDocumentTemplate, Messages.RenameDocumentTemplateHandler_NewName);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean computeEnabled = super.computeEnabled(context);
        if (computeEnabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            computeEnabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return computeEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedDocument = this.getSelectedElement();
        if (ModelExplorerEditionUtil.isHandledByDirectEditor((EObject)selectedDocument)) {
            ModelExplorerEditionUtil.editElement((EObject)selectedDocument);
        } else {
            super.execute(event);
        }
        return null;
    }
}

