/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.modelexplorer.internal.handler;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.papyrus.infra.ui.menu.NamePropertyTester;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.documentview.modelexplorer.internal.action.DocumentQuickFormatAction;

public class DocumentQuickFormatHandler
extends AbstractCommandHandler {
    protected Command getCommand(ExecutionEvent event) {
        String parameter = event.getParameter(NamePropertyTester.PARAMETER_ID);
        DocumentQuickFormatAction action = new DocumentQuickFormatAction(parameter, this.getSelectedElements());
        this.setBaseEnabled(action.isEnabled());
        if (action.isEnabled()) {
            return action.getCommand();
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void setEnabled(Object evaluationContext) {
        DocumentQuickFormatAction action = new DocumentQuickFormatAction("default", this.getSelectedElements());
        this.setBaseEnabled(action.isEnabled());
    }

    protected Command getCommand(IEvaluationContext context) {
        return null;
    }

    protected List<EObject> getSelectedElements() {
        LinkedList<EObject> selectedEObjects = new LinkedList<EObject>();
        for (Object element : this.getSelection()) {
            EObject selectedEObject = EMFHelper.getEObject(element);
            if (!(selectedEObject instanceof Document)) continue;
            selectedEObjects.add(selectedEObject);
        }
        return selectedEObjects;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        return !this.getSelectedElements().isEmpty();
    }
}

