/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.gmf.template2structure.internal.mapping;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.model2doc.integration.gmf.template2structure.Activator;

public class GMFDiagramImageUtils {
    public static final String SVG_EXTENSION = "svg";

    public static void generateImageOfDiagram(Diagram diagram, String pathRoot) {
        IPath folderPath;
        File folder;
        Assert.isTrue((boolean)pathRoot.endsWith(SVG_EXTENSION));
        Path imagePath = new Path(pathRoot.toString());
        if (imagePath.segmentCount() > 1 && !(folder = (folderPath = imagePath.removeLastSegments(1)).toFile()).exists()) {
            folder.mkdirs();
        }
        CopyToImageUtil copyImageUtil = new CopyToImageUtil();
        try {
            copyImageUtil.copyToImage(diagram, (IPath)imagePath, ImageFileFormat.SVG, (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

