/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.parts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;
import org.eclipse.uml2.diagram.common.editpolicies.CreationEditPolicyWithCustomReparent;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionEditPolicy;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.diagram.component.edit.parts.ComponentContents2EditPart;
import org.eclipse.uml2.diagram.component.edit.parts.ComponentNameEditPart;
import org.eclipse.uml2.diagram.component.edit.parts.PortEditPart;
import org.eclipse.uml2.diagram.component.edit.policies.Component2CanonicalEditPolicy;
import org.eclipse.uml2.diagram.component.edit.policies.Component2ItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.component.part.UMLDiagramUpdateCommand;
import org.eclipse.uml2.diagram.component.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.component.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component2EditPart
extends AbstractBorderedShapeEditPart
implements PrimaryShapeEditPart {
    public static final int VISUAL_ID = 3001;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private LinkTargetListener myLinkTargetListener;

    public Component2EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        if (UMLVisualIDRegistry.isShortcutDescendant(this.getNotationView())) {
            this.installEditPolicy(UpdateDescriptionEditPolicy.ROLE, (EditPolicy)new UpdateDescriptionEditPolicy(UMLDiagramUpdater.TYPED_ADAPTER, true));
        }
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicyWithCustomReparent(UMLVisualIDRegistry.TYPED_ADAPTER));
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new Component2ItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new Component2CanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof IBorderItemEditPart) {
                    return new BorderItemSelectionEditPolicy();
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        ComponentFigure figure = new ComponentFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public ComponentFigure getPrimaryShape() {
        return (ComponentFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ComponentNameEditPart) {
            ((ComponentNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureComponentFigure_name());
            return true;
        }
        if (childEditPart instanceof ComponentContents2EditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigureComponentFigure_Body();
            this.setupContentPane((IFigure)pane);
            pane.add(((ComponentContents2EditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PortEditPart) {
            BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((PortEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ComponentContents2EditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigureComponentFigure_Body();
            pane.remove(((ComponentContents2EditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PortEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((PortEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof ComponentContents2EditPart) {
            return this.getPrimaryShape().getFigureComponentFigure_Body();
        }
        if (editPart instanceof PortEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(40));
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5002));
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        this.handleTypeLinkModification(event);
        this.handleFeatureLinkModification(event);
    }

    protected void reorderChild(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        LayoutManager layout = this.getContentPaneFor((IGraphicalEditPart)child).getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        super.reorderChild(child, index);
        this.setLayoutConstraint(child, childFigure, constraint);
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    private LinkTargetListener getLinkTargetListener() {
        if (this.myLinkTargetListener == null) {
            this.myLinkTargetListener = new LinkTargetListener();
        }
        return this.myLinkTargetListener;
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        for (IUpdaterNodeDescriptor iUpdaterNodeDescriptor : this.getComponent_3001ContainedLinks()) {
            EObject nextLink = iUpdaterNodeDescriptor.getModelElement();
            if (nextLink == null) continue;
            switch (iUpdaterNodeDescriptor.getVisualID()) {
                case 4001: {
                    this.getLinkTargetListener().addReferenceListener(nextLink, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    break;
                }
            }
        }
    }

    private List<IUpdaterLinkDescriptor> getComponent_3001ContainedLinks() {
        return UMLDiagramUpdater.getComponent_3001ContainedLinks(this.getNotationView());
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        this.getLinkTargetListener().dispose();
    }

    private void handleTypeLinkModification(Notification event) {
        if (event.getFeature() == UMLPackage.eINSTANCE.getBehavioredClassifier_InterfaceRealization()) {
            block0 : switch (event.getEventType()) {
                case 3: {
                    Object link = event.getNewValue();
                    if (link instanceof InterfaceRealization) {
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    if (!(link instanceof InterfaceRealization)) break;
                    this.refreshDiagram();
                    break;
                }
                case 4: {
                    Object link = event.getOldValue();
                    if (link instanceof InterfaceRealization) {
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    if (!(link instanceof InterfaceRealization)) break;
                    this.refreshDiagram();
                    break;
                }
                case 5: {
                    List links = (List)event.getNewValue();
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.getLinkTargetListener().addReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
                case 6: {
                    List links = (List)event.getOldValue();
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.getLinkTargetListener().removeReferenceListener((EObject)link, (EStructuralFeature)UMLPackage.eINSTANCE.getInterfaceRealization_Contract());
                    }
                    for (Object link : links) {
                        if (!(link instanceof InterfaceRealization)) continue;
                        this.refreshDiagram();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    private void handleFeatureLinkModification(Notification event) {
        if (event.getFeature() == UMLPackage.eINSTANCE.getComponent_Required()) {
            this.refreshDiagram();
            return;
        }
    }

    public void refreshDiagram() {
        UMLDiagramUpdateCommand.performCanonicalUpdate(this.getDiagramView().getElement());
    }

    public class ComponentFigure
    extends RectangleFigure {
        private Label fFigureComponentFigure_name;
        private RectangleFigure fFigureComponentFigure_Body;
        private boolean myUseLocalCoordinates = false;

        public ComponentFigure() {
            BorderLayout layoutThis = new BorderLayout();
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setFill(false);
            this.setOutline(false);
            this.createContents();
        }

        private void createContents() {
            RectangleFigure componentFigure_LabelsContainer0 = new RectangleFigure();
            componentFigure_LabelsContainer0.setMinimumSize(new Dimension(Component2EditPart.this.getMapMode().DPtoLP(0), Component2EditPart.this.getMapMode().DPtoLP(35)));
            this.add((IFigure)componentFigure_LabelsContainer0, BorderLayout.TOP);
            ToolbarLayout layoutComponentFigure_LabelsContainer0 = new ToolbarLayout();
            layoutComponentFigure_LabelsContainer0.setStretchMinorAxis(true);
            layoutComponentFigure_LabelsContainer0.setMinorAlignment(0);
            layoutComponentFigure_LabelsContainer0.setSpacing(0);
            layoutComponentFigure_LabelsContainer0.setVertical(true);
            componentFigure_LabelsContainer0.setLayoutManager((LayoutManager)layoutComponentFigure_LabelsContainer0);
            Label componentFigure_fixed_component1 = new Label();
            componentFigure_fixed_component1.setText("\u00abcomponent\u00bb");
            componentFigure_LabelsContainer0.add((IFigure)componentFigure_fixed_component1);
            this.fFigureComponentFigure_name = new Label();
            this.fFigureComponentFigure_name.setText("");
            componentFigure_LabelsContainer0.add((IFigure)this.fFigureComponentFigure_name);
            this.fFigureComponentFigure_Body = new RectangleFigure();
            this.fFigureComponentFigure_Body.setMinimumSize(new Dimension(Component2EditPart.this.getMapMode().DPtoLP(0), Component2EditPart.this.getMapMode().DPtoLP(55)));
            this.add((IFigure)this.fFigureComponentFigure_Body, BorderLayout.CENTER);
        }

        public Label getFigureComponentFigure_name() {
            return this.fFigureComponentFigure_name;
        }

        public RectangleFigure getFigureComponentFigure_Body() {
            return this.fFigureComponentFigure_Body;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }

    private class LinkTargetListener
    implements NotificationListener {
        Map<EObject, Set<EStructuralFeature>> myNotifiers = new HashMap<EObject, Set<EStructuralFeature>>();

        private LinkTargetListener() {
        }

        private void added(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                this.myNotifiers.put(link, new HashSet());
            }
            this.myNotifiers.get(link).add(feature);
        }

        private void removed(EObject link, EStructuralFeature feature) {
            if (!this.myNotifiers.containsKey(link)) {
                return;
            }
            this.myNotifiers.get(link).remove(feature);
        }

        public void dispose() {
            Set<Map.Entry<EObject, Set<EStructuralFeature>>> entrySet = this.myNotifiers.entrySet();
            for (Map.Entry<EObject, Set<EStructuralFeature>> entry : entrySet) {
                for (EStructuralFeature feature : entry.getValue()) {
                    Component2EditPart.this.getDiagramEventBroker().removeNotificationListener(entry.getKey(), (Object)feature, (NotificationListener)this);
                }
            }
        }

        private void removeReferenceListener(EObject link, EStructuralFeature feature) {
            Component2EditPart.this.getDiagramEventBroker().removeNotificationListener(link, (Object)feature, (NotificationListener)this);
            this.removed(link, feature);
        }

        private void addReferenceListener(EObject link, EStructuralFeature feature) {
            Component2EditPart.this.getDiagramEventBroker().addNotificationListener(link, feature, (NotificationListener)this);
            this.added(link, feature);
        }

        public void notifyChanged(Notification event) {
            if (event.getFeature() == UMLPackage.eINSTANCE.getInterfaceRealization_Contract()) {
                Component2EditPart.this.refreshDiagram();
                return;
            }
        }
    }
}

