/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.horizontal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;

class FramesManager {
    private int myLifeLineIndex;
    private Map myLMFrame2frameInfo;

    FramesManager(List lmRootFramesList) {
        this.myLMFrame2frameInfo = new HashMap(lmRootFramesList.size());
        this.createFrameInfos(lmRootFramesList);
    }

    public Iterator frameInfos() {
        return this.myLMFrame2frameInfo.values().iterator();
    }

    int getLifeLineIndex() {
        return this.myLifeLineIndex;
    }

    void setLifeLineIndex(int index) {
        this.myLifeLineIndex = index;
    }

    public FrameInfo frameReferenceStarted(LMFrame lmFrame) {
        FrameInfo frameInfo = this.getFrameInfo(lmFrame);
        frameInfo.tieToLifeLine(this.myLifeLineIndex);
        return frameInfo;
    }

    public void frameReferenceFinished(LMFrame lmFrame) {
        lmFrame.checkConsistancy();
    }

    public FrameInfo getFrameInfo(LMFrame lmFrame) {
        FrameInfo result = (FrameInfo)this.myLMFrame2frameInfo.get(lmFrame);
        if (result == null) {
            throw new RuntimeException("Unknown frame");
        }
        return result;
    }

    boolean isCurrentLifelineOutermost(FrameInfo info) {
        return this.myLifeLineIndex == info.getMinLifeLineIndex() || this.myLifeLineIndex == info.getMaxLifeLineIndex();
    }

    private void createFrameInfos(List lmFramesList) {
        int i = 0;
        while (i < lmFramesList.size()) {
            LMFrame lmFrame = (LMFrame)lmFramesList.get(i);
            this.myLMFrame2frameInfo.put(lmFrame, new FrameInfo(lmFrame));
            this.createFrameInfos(lmFrame.getChildList());
            ++i;
        }
    }

    static class FrameInfo {
        private int myMaxLeftBraketPos;
        private int myMaxRightBraketPos;
        private final LMFrame myLMFrame;
        private FrameInfo myParentFrameInfo = null;
        private int myMaxLifeLineIndex = -1;
        private int myMinLifeLineIndex = -1;

        FrameInfo(LMFrame lmFrame) {
            this.myLMFrame = lmFrame;
        }

        LMFrame getLMFrame() {
            return this.myLMFrame;
        }

        void setMaxBracketPos(int lifeline, int maxLeftBraketPos, int maxRightBraketPos) {
            if (this.myMinLifeLineIndex == lifeline) {
                this.myMaxLeftBraketPos = maxLeftBraketPos;
            }
            if (this.myMaxLifeLineIndex == lifeline) {
                this.myMaxRightBraketPos = maxRightBraketPos;
            }
        }

        int getMaxLeftBraketPos() {
            return this.myMaxLeftBraketPos;
        }

        int getMaxRightBraketPos() {
            return this.myMaxRightBraketPos;
        }

        void tieToLifeLine(int lifeLineIndex) {
            if (this.myMaxLifeLineIndex == -1) {
                this.myMaxLifeLineIndex = lifeLineIndex;
                this.myMinLifeLineIndex = lifeLineIndex;
            } else {
                if (this.myMaxLifeLineIndex < lifeLineIndex) {
                    this.myMaxLifeLineIndex = lifeLineIndex;
                    this.myMaxRightBraketPos = 0;
                }
                if (this.myMinLifeLineIndex > lifeLineIndex) {
                    this.myMinLifeLineIndex = lifeLineIndex;
                    this.myMaxLeftBraketPos = 0;
                }
            }
        }

        int getMaxLifeLineIndex() {
            return this.myMaxLifeLineIndex;
        }

        int getMinLifeLineIndex() {
            return this.myMinLifeLineIndex;
        }

        public String toString() {
            return "<FrameInfo:hasParent=" + (this.myParentFrameInfo != null) + ":myMaxLifeLineIndex=" + this.myMaxLifeLineIndex + ":myMinLifeLineIndex=" + this.myMinLifeLineIndex + ">";
        }
    }
}

