/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.BracketMetaObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingRegion;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmBracketsList;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmTileMountingRegion;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SDVerticalLayoutInputImpl;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;

class LmTileFloorMountingRegion
extends LMMountingRegion {
    private LmBracketsList myBracketsList = new LmBracketsList(){
        private final List myTilesList = new ArrayList();
        private final List myUnmodifableList = Collections.unmodifiableList(this.myTilesList);

        public List getListView() {
            return this.myUnmodifableList;
        }

        public Iterator iterator() {
            return this.myUnmodifableList.iterator();
        }

        public int size() {
            return this.myTilesList.size();
        }

        public void reorderList(List oldIndexList) {
            if (this.myTilesList.size() != oldIndexList.size()) {
                throw new RuntimeException("Wrong number of elements to replace");
            }
            ArrayList newList = new ArrayList(this.myTilesList.size());
            for (Integer oldIndex : oldIndexList) {
                int index = oldIndex;
                newList.add(this.myTilesList.get(index));
            }
            int i = 0;
            while (i < this.myTilesList.size()) {
                LmTileMountingRegion tile = (LmTileMountingRegion)this.myTilesList.get(i);
                tile.setTopHolder(null);
                tile.setBottomHolder(null);
                ++i;
            }
            this.myTilesList.clear();
            LmTileFloorMountingRegion.this.myMiddleLifeLineElements.clear();
            this.myTilesList.addAll(newList);
            int listSize = this.myTilesList.size();
            if (listSize != 0) {
                LmTileMountingRegion firstTile = (LmTileMountingRegion)this.myTilesList.get(0);
                LmTileFloorMountingRegion.this.myFirstTopHolder.setTileMountingRegion(firstTile);
                firstTile.setTopHolder(LmTileFloorMountingRegion.this.myFirstTopHolder);
                int i2 = 1;
                while (i2 < listSize) {
                    LmTileMountingRegion tile1 = (LmTileMountingRegion)this.myTilesList.get(i2 - 1);
                    LmTileMountingRegion tile2 = (LmTileMountingRegion)this.myTilesList.get(i2);
                    MiddleLifeLineElement middleLifeLineElement = new MiddleLifeLineElement(tile1, tile2);
                    LmTileFloorMountingRegion.this.myMiddleLifeLineElements.add(middleLifeLineElement);
                    tile1.setBottomHolder(middleLifeLineElement.getBottomHolder());
                    tile2.setTopHolder(middleLifeLineElement.getTopHolder());
                    ++i2;
                }
                LmTileMountingRegion lastTile = (LmTileMountingRegion)this.myTilesList.get(listSize - 1);
                lastTile.setBottomHolder(LmTileFloorMountingRegion.this.myLastBottomHolder);
                LmTileFloorMountingRegion.this.myLastBottomHolder.setTileMountingRegion(lastTile);
            }
        }

        public void add(LMLifeLineBracket lifeLineBracket) {
            LmTileMountingRegion tile = (LmTileMountingRegion)lifeLineBracket;
            int listSize = this.myTilesList.size();
            if (listSize == 0) {
                LmTileFloorMountingRegion.this.myFirstTopHolder.setTileMountingRegion(tile);
                tile.setTopHolder(LmTileFloorMountingRegion.this.myFirstTopHolder);
            } else {
                LmTileMountingRegion prevTile = (LmTileMountingRegion)this.myTilesList.get(listSize - 1);
                prevTile.setBottomHolder(null);
                MiddleLifeLineElement middleLifeLineElement = new MiddleLifeLineElement(prevTile, tile);
                LmTileFloorMountingRegion.this.myMiddleLifeLineElements.add(middleLifeLineElement);
                prevTile.setBottomHolder(middleLifeLineElement.getBottomHolder());
                tile.setTopHolder(middleLifeLineElement.getTopHolder());
            }
            tile.setBottomHolder(LmTileFloorMountingRegion.this.myLastBottomHolder);
            LmTileFloorMountingRegion.this.myLastBottomHolder.setTileMountingRegion(tile);
            this.myTilesList.add(tile);
        }

        public void remove(LMLifeLineBracket lifeLineBracket) {
            LmTileMountingRegion tile = (LmTileMountingRegion)lifeLineBracket;
            int index = this.myTilesList.indexOf(tile);
            if (index == -1) {
                throw new RuntimeException("Cannot find tile item in list");
            }
            tile.setTopHolder(null);
            tile.setBottomHolder(null);
            int listSize = this.myTilesList.size();
            if (listSize == 1) {
                this.myTilesList.clear();
                LmTileFloorMountingRegion.this.myFirstTopHolder.setTileMountingRegion(null);
                LmTileFloorMountingRegion.this.myLastBottomHolder.setTileMountingRegion(null);
            } else {
                if (index == 0) {
                    LmTileFloorMountingRegion.this.myMiddleLifeLineElements.remove(0);
                    LmTileMountingRegion tile1 = (LmTileMountingRegion)this.myTilesList.get(1);
                    LmTileFloorMountingRegion.this.myFirstTopHolder.setTileMountingRegion(tile1);
                    tile1.setTopHolder(null);
                    tile1.setTopHolder(LmTileFloorMountingRegion.this.myFirstTopHolder);
                } else if (index == listSize - 1) {
                    LmTileFloorMountingRegion.this.myMiddleLifeLineElements.remove(listSize - 2);
                    LmTileMountingRegion tilePre = (LmTileMountingRegion)this.myTilesList.get(listSize - 2);
                    LmTileFloorMountingRegion.this.myLastBottomHolder.setTileMountingRegion(tilePre);
                    tilePre.setBottomHolder(null);
                    tilePre.setBottomHolder(LmTileFloorMountingRegion.this.myLastBottomHolder);
                } else {
                    LmTileFloorMountingRegion.this.myMiddleLifeLineElements.remove(index);
                    LmTileMountingRegion tile1 = (LmTileMountingRegion)this.myTilesList.get(index - 1);
                    LmTileMountingRegion tile2 = (LmTileMountingRegion)this.myTilesList.get(index + 1);
                    tile1.setBottomHolder(null);
                    tile2.setTopHolder(null);
                    MiddleLifeLineElement middleLifeLineElement = new MiddleLifeLineElement(tile1, tile2);
                    LmTileFloorMountingRegion.this.myMiddleLifeLineElements.set(index - 1, middleLifeLineElement);
                    tile1.setBottomHolder(middleLifeLineElement.getBottomHolder());
                    tile2.setTopHolder(middleLifeLineElement.getTopHolder());
                }
                this.myTilesList.remove(index);
            }
        }

        public boolean isEmpty() {
            return this.myTilesList.isEmpty();
        }

        public void removeAll() {
            this.myTilesList.clear();
            LmTileFloorMountingRegion.this.myMiddleLifeLineElements.clear();
        }

        boolean checkCorrectState() {
            if (this.myTilesList.isEmpty()) {
                if (!LmTileFloorMountingRegion.this.myMiddleLifeLineElements.isEmpty()) {
                    throw new RuntimeException("bad state");
                }
                return true;
            }
            int listSize = this.myTilesList.size();
            LmTileMountingRegion firstTile = (LmTileMountingRegion)this.myTilesList.get(0);
            if (LmTileFloorMountingRegion.this.myFirstTopHolder.getTileMountingRegion() != firstTile) {
                throw new RuntimeException("bad state");
            }
            if (firstTile.getTopHolder() != LmTileFloorMountingRegion.this.myFirstTopHolder) {
                throw new RuntimeException("bad state");
            }
            int i = 1;
            while (i < listSize) {
                LmTileMountingRegion tile1 = (LmTileMountingRegion)this.myTilesList.get(i - 1);
                LmTileMountingRegion tile2 = (LmTileMountingRegion)this.myTilesList.get(i);
                MiddleLifeLineElement middleLifeLineElement = (MiddleLifeLineElement)LmTileFloorMountingRegion.this.myMiddleLifeLineElements.get(i - 1);
                if (middleLifeLineElement.getTopTile() != tile1) {
                    throw new RuntimeException("bad state");
                }
                if (middleLifeLineElement.getBottomTile() != tile2) {
                    throw new RuntimeException("bad state");
                }
                if (tile1.getBottomHolder() != middleLifeLineElement.getBottomHolder()) {
                    throw new RuntimeException("bad state");
                }
                if (tile2.getTopHolder() != middleLifeLineElement.getTopHolder()) {
                    throw new RuntimeException("bad state");
                }
                ++i;
            }
            LmTileMountingRegion lastTile = (LmTileMountingRegion)this.myTilesList.get(listSize - 1);
            if (LmTileFloorMountingRegion.this.myLastBottomHolder.getTileMountingRegion() != lastTile) {
                throw new RuntimeException("bad state");
            }
            if (lastTile.getBottomHolder() != LmTileFloorMountingRegion.this.myLastBottomHolder) {
                throw new RuntimeException("bad state");
            }
            return true;
        }
    };
    private final List myMiddleLifeLineElements = new ArrayList();
    private final FirstTopHolder myFirstTopHolder = new FirstTopHolder();
    private final LastBottomHolder myLastBottomHolder = new LastBottomHolder();

    LmTileFloorMountingRegion(AbsNode gdeBracketNode, BracketMetaObject bracketMetaObject, LmOwner lmOwner) {
        super(gdeBracketNode, bracketMetaObject, lmOwner);
    }

    public LmBracketsList getChildBracketsList() {
        return this.myBracketsList;
    }

    public SDVerticalLayoutInputImpl.NullFreeIterator verticalLayoutElements() {
        return new SDVerticalLayoutInputImpl.NullFreeIterator(){
            private int myState = 0;
            private boolean myTileElementsReturned;
            private int myTilePos;

            public Object next() {
                switch (this.myState) {
                    case 0: {
                        if (LmTileFloorMountingRegion.this.myBracketsList.isEmpty()) {
                            this.myState = 2;
                        } else {
                            this.myState = 1;
                            this.myTileElementsReturned = false;
                            this.myTilePos = 0;
                        }
                        return LmTileFloorMountingRegion.this.myFirstTopHolder;
                    }
                    case 1: {
                        if (this.myTileElementsReturned) {
                            this.myTileElementsReturned = false;
                            MiddleLifeLineElement middleLifeLineElement = (MiddleLifeLineElement)LmTileFloorMountingRegion.this.myMiddleLifeLineElements.get(this.myTilePos);
                            ++this.myTilePos;
                            return middleLifeLineElement;
                        }
                        if (this.myTilePos >= LmTileFloorMountingRegion.this.myBracketsList.size() - 1) {
                            this.myState = 2;
                        } else {
                            this.myTileElementsReturned = true;
                        }
                        LmTileMountingRegion mountingRegion = (LmTileMountingRegion)LmTileFloorMountingRegion.this.myBracketsList.getListView().get(this.myTilePos);
                        return mountingRegion.verticalLayoutElements();
                    }
                    case 2: {
                        this.myState = 3;
                        return LmTileFloorMountingRegion.this.myLastBottomHolder;
                    }
                    case 3: {
                        return null;
                    }
                }
                throw new IllegalStateException("state = " + this.myState);
            }
        };
    }

    void setMountLink(LMMountingLink mountingLink) {
        super.setMountLink(mountingLink);
        if (mountingLink == null) {
            this.myFirstTopHolder.setHorizontalConstraint(null);
            this.myLastBottomHolder.setHorizontalConstraint(null);
        } else {
            LMFrame frame = mountingLink.getFrame();
            this.myFirstTopHolder.setHorizontalConstraint(frame.getTopConstraint());
            this.myLastBottomHolder.setHorizontalConstraint(frame.getBottomConstraint());
        }
    }

    LMMountingRegion.MountingRegionLifelineElement getTopLifeLineElementForConstraint() {
        return this.myFirstTopHolder;
    }

    LMMountingRegion.MountingRegionLifelineElement getBottomLifeLineElementForConstraint() {
        return this.myLastBottomHolder;
    }

    void setYAndHeightFromFrame(int y, int height, JustReshapedState justReshapedState) {
        this.setJustReshaped(justReshapedState);
        this.myFirstTopHolder.setPositionValue(y, true);
        this.myLastBottomHolder.setPositionValue(y + height, true);
    }

    private abstract class EdgeTopOrBottomHolder
    extends SDVerticalLayoutInputImpl.LifeLineElementGen
    implements LifeLineElement.Position,
    LMMountingRegion.MountingRegionLifelineElement {
        private LmTileMountingRegion myTileMountingRegion;
        private final LMMountingRegion.MountingRegionPosition myFloorBracketPosition;

        protected EdgeTopOrBottomHolder(int topOffset, int bottomOffset, LMMountingRegion.MountingRegionPosition floorBracketPosition) {
            super(topOffset, topOffset + bottomOffset);
            this.myFloorBracketPosition = floorBracketPosition;
        }

        public LifeLine getLifeLine() {
            return LmTileFloorMountingRegion.this.getLifeLine().getVerticalLayoutLifeLine();
        }

        public LifeLineElement.Position getPosition() {
            return this;
        }

        public int getPositionValue() {
            return this.myFloorBracketPosition.getPositionValue();
        }

        public void setPositionValue(int pos) {
            this.setPositionValue(pos, false);
        }

        public void setConstraintInvalid(boolean isInvalid) {
            LmTileFloorMountingRegion.this.getMountingLink().setInvalid(isInvalid);
            if (this.myTileMountingRegion != null) {
                this.myTileMountingRegion.getMountingLink().setInvalid(isInvalid);
            }
        }

        void setPositionValue(int pos, boolean doNotReshapeFrame) {
            this.myFloorBracketPosition.setPositionValue(pos, doNotReshapeFrame);
            if (this.myTileMountingRegion != null) {
                this.getTilePosition(this.myTileMountingRegion).setPositionValue(pos, doNotReshapeFrame);
            }
        }

        public boolean isFirstPrioritedPosition() {
            return this.myFloorBracketPosition.isFirstPrioritedPosition();
        }

        public boolean isLastPrioritedPosition() {
            return this.myFloorBracketPosition.isLastPrioritedPosition();
        }

        void setTileMountingRegion(LmTileMountingRegion tileMountingRegion) {
            this.myTileMountingRegion = tileMountingRegion;
        }

        LmTileMountingRegion getTileMountingRegion() {
            return this.myTileMountingRegion;
        }

        public void setVerticalPositionFromFrame(int y, JustReshapedState justReshapedState) {
            this.setPositionValue(y, true);
        }

        protected abstract LmTileMountingRegion.TileEdgePosition getTilePosition(LmTileMountingRegion var1);
    }

    private class FirstTopHolder
    extends EdgeTopOrBottomHolder
    implements LifeLineElement.Position,
    LmTileMountingRegion.TopHolder {
        protected FirstTopHolder() {
            super(6, 20, new LMMountingRegion.MountingRegionTopPosition());
        }

        protected LmTileMountingRegion.TileEdgePosition getTilePosition(LmTileMountingRegion tileMountingRegion) {
            return tileMountingRegion.getTopPosition();
        }

        public LMMountingRegion.MountingRegionLifelineElement getConstraintedElement() {
            return null;
        }

        public void setHorizontalConstrinat(HorizontalConstraint horizontalConstraint) {
            throw new UnsupportedOperationException("no constraints here");
        }

        public boolean isVirtual() {
            return false;
        }

        public String toString() {
            EObject nodeEntity = LmTileFloorMountingRegion.this.getGdeNode().getModelEntity();
            return "FloorTopElement:" + nodeEntity;
        }
    }

    private class LastBottomHolder
    extends EdgeTopOrBottomHolder
    implements LifeLineElement.Position,
    LmTileMountingRegion.BottomHolder {
        protected LastBottomHolder() {
            super(10, 6, new LMMountingRegion.MountingRegionBottomPosition());
        }

        protected LmTileMountingRegion.TileEdgePosition getTilePosition(LmTileMountingRegion tileMountingRegion) {
            return tileMountingRegion.getBottomPosition();
        }

        public boolean isVirtual() {
            return false;
        }

        public String toString() {
            EObject nodeEntity = LmTileFloorMountingRegion.this.getGdeNode().getModelEntity();
            return "FloorBottomElement:" + nodeEntity;
        }
    }

    private class MiddleLifeLineElement
    extends SDVerticalLayoutInputImpl.LifeLineElementGen
    implements LifeLineElement.Position,
    LmTileMountingRegion.TopHolder,
    LmTileMountingRegion.BottomHolder,
    LMMountingRegion.MountingRegionLifelineElement {
        private final LmTileMountingRegion myTopTile;
        private final LmTileMountingRegion myBottomTile;

        MiddleLifeLineElement(LmTileMountingRegion topTile, LmTileMountingRegion bottomTile) {
            super(10, 20);
            this.myTopTile = topTile;
            this.myBottomTile = bottomTile;
        }

        LmTileMountingRegion getBottomTile() {
            return this.myBottomTile;
        }

        LmTileMountingRegion getTopTile() {
            return this.myTopTile;
        }

        public LmTileMountingRegion.TopHolder getTopHolder() {
            return this;
        }

        public LmTileMountingRegion.BottomHolder getBottomHolder() {
            return this;
        }

        public int getPositionValue() {
            return this.myTopTile.getBottomPosition().getPositionValue();
        }

        public void setPositionValue(int pos) {
            this.setPositionValue(pos, false);
        }

        void setPositionValue(int pos, boolean doNotReshapeFrame) {
            this.myTopTile.getBottomPosition().setPositionValue(pos, doNotReshapeFrame);
            this.myBottomTile.getTopPosition().setPositionValue(pos, doNotReshapeFrame);
        }

        public boolean isVirtual() {
            return false;
        }

        public boolean isFirstPrioritedPosition() {
            return false;
        }

        public boolean isLastPrioritedPosition() {
            return false;
        }

        public LifeLine getLifeLine() {
            return LmTileFloorMountingRegion.this.getLifeLine().getVerticalLayoutLifeLine();
        }

        public LifeLineElement.Position getPosition() {
            return this;
        }

        public LMMountingRegion.MountingRegionLifelineElement getConstraintedElement() {
            return this;
        }

        public void setHorizontalConstrinat(HorizontalConstraint horizontalConstraint) {
            super.setHorizontalConstraint(horizontalConstraint);
        }

        public void setVerticalPositionFromFrame(int y, JustReshapedState justReshapedState) {
            this.setPositionValue(y, true);
        }

        public void setConstraintInvalid(boolean isInvalid) {
            LMMountingLink bottomMountingLink;
            LMMountingLink topMountingLink = this.myTopTile.getMountingLink();
            if (topMountingLink != null) {
                topMountingLink.setInvalid(isInvalid);
            }
            if ((bottomMountingLink = this.myBottomTile.getMountingLink()) != null) {
                bottomMountingLink.setInvalid(isInvalid);
            }
        }

        public String toString() {
            EObject nodeEntity = LmTileFloorMountingRegion.this.getGdeNode().getModelEntity();
            return "FloorMiddleElement:" + nodeEntity;
        }
    }
}

