/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.reasoner.structural;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.eclipse.eodm.OWLFactory;
import org.eclipse.eodm.owl.owlbase.IntersectionClass;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.Property;
import org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.UnionClass;
import org.eclipse.eodm.owl.reasoner.structural.AllValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.CTNode;
import org.eclipse.eodm.owl.reasoner.structural.Cardinality;
import org.eclipse.eodm.owl.reasoner.structural.Concept;
import org.eclipse.eodm.owl.reasoner.structural.ContainmentLink;
import org.eclipse.eodm.owl.reasoner.structural.Intersection;
import org.eclipse.eodm.owl.reasoner.structural.MaxCardinality;
import org.eclipse.eodm.owl.reasoner.structural.MinCardinality;
import org.eclipse.eodm.owl.reasoner.structural.Negation;
import org.eclipse.eodm.owl.reasoner.structural.OWLStructuralSubsumptionReasoner;
import org.eclipse.eodm.owl.reasoner.structural.ObjectProp;
import org.eclipse.eodm.owl.reasoner.structural.PrimitiveConcept;
import org.eclipse.eodm.owl.reasoner.structural.RBox;
import org.eclipse.eodm.owl.reasoner.structural.ReasonerUtil;
import org.eclipse.eodm.owl.reasoner.structural.Role;
import org.eclipse.eodm.owl.reasoner.structural.SomeValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.TBox;
import org.eclipse.eodm.owl.reasoner.structural.TermFactory;
import org.eclipse.eodm.owl.reasoner.structural.Union;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;

public class Test {
    static int index = 0;
    private static int[][] sum = new int[100][100];
    static ObjectProp R;
    static ObjectProp S;
    static RBox rbox;
    static Concept A;
    static Concept B;
    static Concept C;
    static Concept D;
    private static Random random;

    static {
        int i = 0;
        while (i < 100) {
            Test.sum[0][i] = 1;
            ++i;
        }
        i = 1;
        while (i < 100) {
            int j = i;
            while (j >= 1) {
                Test.sum[i][j] = sum[i - j][j];
                if (j < i) {
                    int[] nArray = sum[i];
                    int n = j;
                    nArray[n] = nArray[n] + sum[i][j + 1];
                }
                --j;
            }
            j = i + 1;
            while (j < 100) {
                Test.sum[i][j] = 0;
                ++j;
            }
            ++i;
        }
        R = TermFactory.instance().createObjectProp("R");
        S = TermFactory.instance().createObjectProp("S");
        rbox = new RBox();
        A = TermFactory.instance().createPrim("A");
        B = TermFactory.instance().createPrim("B");
        C = TermFactory.instance().createPrim("C");
        D = TermFactory.instance().createPrim("D");
        rbox.addSubPropertyOfAxiom(R, S);
        random = new Random(3L);
    }

    public static void main(String[] argv) {
        Test.testNormalize();
        Test.testDNFandCNFs();
        Test.testNormalizeDC();
        Test.testResolution();
        Test.testToAllForms();
        Test.testTBox();
        Test.testReasoner();
    }

    private static void testReasoner() {
        OWLFactory factory = OWLFactory.eINSTANCE;
        try {
            OWLGraph graph = factory.createOWLGraph("http://graph.test.org");
            OWLOntology ontology = factory.createOWLOntology(graph, "http://test.org");
            ontology.getOwlGraph().add((Object)graph);
            OWLClass a = factory.createOWLClass(graph, "http://test.org#A");
            OWLClass b = factory.createOWLClass(graph, "http://test.org#B");
            OWLClass c = factory.createOWLClass(graph, "http://test.org#C");
            OWLClass d = factory.createOWLClass(graph, "http://test.org#D");
            OWLClass e = factory.createOWLClass(graph, "http://test.org#E");
            OWLClass f = factory.createOWLClass(graph, "http://test.org#F");
            IntersectionClass in = factory.createIntersectionClass(graph);
            in.getOWLintersectionOf().add((Object)b);
            in.getOWLintersectionOf().add((Object)c);
            a.getEquivalentClass().add((Object)in);
            UnionClass un = factory.createUnionClass(graph);
            un.getOWLunionOf().add((Object)b);
            un.getOWLunionOf().add((Object)c);
            d.getEquivalentClass().add((Object)un);
            OWLObjectProperty p1 = factory.createOWLObjectProperty(graph, "http://test.org#p1");
            OWLObjectProperty p2 = factory.createOWLObjectProperty(graph, "http://test.org#p2");
            p1.getSubProperty().add((Object)p2);
            SomeValuesFromRestriction aP1A = factory.createSomeValuesFromRestriction(graph);
            aP1A.setOWLonProperty((RDFProperty)p1);
            aP1A.setSomeValuesFromClass(a);
            e.getEquivalentClass().add((Object)aP1A);
            SomeValuesFromRestriction aP2A = factory.createSomeValuesFromRestriction(graph);
            aP2A.setOWLonProperty((RDFProperty)p2);
            aP2A.setSomeValuesFromClass(a);
            f.getEquivalentClass().add((Object)aP2A);
            OWLStructuralSubsumptionReasoner reasoner = new OWLStructuralSubsumptionReasoner();
            reasoner.initialize(ontology);
            if (reasoner.isSubPropertyOf((Property)p2, (Property)p1)) {
                System.out.println("p2 is subproperty of p1");
            } else {
                System.out.println("p2 is not subproperty of p1");
            }
            List l = reasoner.getDescendantClasses(e);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                OWLClass clazz = (OWLClass)it.next();
                System.out.println(clazz.getURI());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testTBox() {
        TBox tbox = new TBox(rbox);
        Intersection AandB = TermFactory.instance().createIntersect(A, B);
        Union AorB = TermFactory.instance().createUnion(A, B);
        AllValueFrom aRA = TermFactory.instance().createAll(R, A);
        AllValueFrom aSA = TermFactory.instance().createAll(S, A);
        tbox.addConcept(AandB);
        tbox.addConcept(AorB);
        tbox.addConcept(aRA);
        tbox.addConcept(aSA);
        Test.show(tbox);
    }

    private static void testToAllForms() {
        int i = 0;
        while (i < 4) {
            Concept c = Test.createRandomClass(10);
            Concept[] forms = ReasonerUtil.getAllForms(c, rbox);
            System.out.println("Orignal: " + ReasonerUtil.toString(c) + "\ntoMinDNF: " + ReasonerUtil.toString(forms[0]) + "\ntoMaxCNF: " + ReasonerUtil.toString(forms[1]));
            ++i;
        }
    }

    private static void testNormalizeDC() {
        Intersection BandC = TermFactory.instance().createIntersect(B, C);
        Union eq1 = TermFactory.instance().createUnion(A, BandC);
        System.out.println("Orignal: " + ReasonerUtil.toString(eq1) + "\ntoDNF:" + ReasonerUtil.toString(ReasonerUtil.toDNF(eq1, false)) + "\nCNF:" + ReasonerUtil.toString(ReasonerUtil.toCNF(eq1, false)));
    }

    private static void testNormalize() {
        PrimitiveConcept A = TermFactory.instance().createPrim("A");
        PrimitiveConcept B = TermFactory.instance().createPrim("B");
        RBox rbox = new RBox();
        ObjectProp r = TermFactory.instance().createObjectProp("r");
        ObjectProp s = TermFactory.instance().createObjectProp("s");
        rbox.addSubPropertyOfAxiom(s, r);
        AllValueFrom arA = TermFactory.instance().createAll(r, A);
        AllValueFrom asB = TermFactory.instance().createAll(s, B);
        Intersection arAandasB = TermFactory.instance().createIntersect(arA, asB);
        System.out.println("R1 Orignal: " + ReasonerUtil.toString(arAandasB) + "\ntoMinimalDNF:" + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandasB, rbox)));
        SomeValueFrom ssB = TermFactory.instance().createSome(s, B);
        Intersection arAandssB = TermFactory.instance().createIntersect(arA, ssB);
        System.out.println("R3 Orignal: " + ReasonerUtil.toString(arAandssB) + "\ntoMinimalDNF:" + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandssB, rbox)));
        MinCardinality mnsB = TermFactory.instance().createMinCardinality(s, 2, B);
        Intersection arAandmnsB = TermFactory.instance().createIntersect(arA, mnsB);
        System.out.println("R3' Orignal: " + ReasonerUtil.toString(arAandmnsB) + "\ntoMinimalDNF:" + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandmnsB, rbox)));
        Cardinality ensB = TermFactory.instance().createCardinality(s, 5, B);
        Intersection arAandensB = TermFactory.instance().createIntersect(arA, ensB);
        System.out.println("R5 Orignal: " + ReasonerUtil.toString(arAandensB) + "\ntoMinimalDNF:" + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandensB, rbox)));
        MaxCardinality maxnsB = TermFactory.instance().createMaxCardinality(s, 5, B);
        Intersection arAandmaxnsB = TermFactory.instance().createIntersect(arA, maxnsB);
        System.out.println("R7 Orignal: " + ReasonerUtil.toString(arAandmaxnsB) + "\ntoMinimalDNF:" + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandmaxnsB, rbox)));
        System.out.println();
        SomeValueFrom srA = TermFactory.instance().createSome(r, A);
        ssB = TermFactory.instance().createSome(s, B);
        Union srAorssB = TermFactory.instance().createUnion(srA, ssB);
        System.out.println("R2 Orignal: " + ReasonerUtil.toString(srAorssB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAorssB, rbox)));
        MinCardinality m1rA = TermFactory.instance().createMinCardinality(r, 1, A);
        mnsB = TermFactory.instance().createMinCardinality(s, 2, B);
        Union m1rAormnsB = TermFactory.instance().createUnion(m1rA, mnsB);
        System.out.println("R2' Orignal: " + ReasonerUtil.toString(m1rAormnsB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAormnsB, rbox)));
        asB = TermFactory.instance().createAll(s, B);
        Union srAorasB = TermFactory.instance().createUnion(srA, asB);
        System.out.println("R4 Orignal: " + ReasonerUtil.toString(srAorasB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAorasB, rbox)));
        asB = TermFactory.instance().createAll(s, B);
        Union m1rAorasB = TermFactory.instance().createUnion(m1rA, asB);
        System.out.println("R4' Orignal: " + ReasonerUtil.toString(m1rAorasB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAorasB, rbox)));
        ensB = TermFactory.instance().createCardinality(s, 5, B);
        Union m1rAorensB = TermFactory.instance().createUnion(m1rA, ensB);
        System.out.println("R6 Orignal: " + ReasonerUtil.toString(m1rAorensB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAorensB, rbox)));
        ensB = TermFactory.instance().createCardinality(s, 5, B);
        Union srAorensB = TermFactory.instance().createUnion(srA, ensB);
        System.out.println("R6' Orignal: " + ReasonerUtil.toString(srAorensB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAorensB, rbox)));
        maxnsB = TermFactory.instance().createMaxCardinality(s, 5, B);
        Union m1rAormaxnsB = TermFactory.instance().createUnion(m1rA, maxnsB);
        System.out.println("R8 Orignal: " + ReasonerUtil.toString(m1rAormaxnsB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAormaxnsB, rbox)));
        maxnsB = TermFactory.instance().createMaxCardinality(s, 5, B);
        Union srAormaxnsB = TermFactory.instance().createUnion(srA, maxnsB);
        System.out.println("R8' Orignal: " + ReasonerUtil.toString(srAormaxnsB) + "\ntoMaximalCNF:" + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAormaxnsB, rbox)));
    }

    public static void testResolution() {
        PrimitiveConcept C = TermFactory.instance().createPrim("C");
        PrimitiveConcept D = TermFactory.instance().createPrim("D");
        PrimitiveConcept E = TermFactory.instance().createPrim("E");
        Negation NC = TermFactory.instance().createNegation(C);
        Negation ND = TermFactory.instance().createNegation(D);
        Negation NE = TermFactory.instance().createNegation(E);
        Intersection CandD = TermFactory.instance().createIntersect(C, D);
        Union NDorNE = TermFactory.instance().createUnion(ND, NE);
        Union NCorE = TermFactory.instance().createUnion(NC, E);
        Intersection term = TermFactory.instance().createIntersect(CandD, NDorNE);
        term.addIntersectOf(NCorE);
        System.out.println(ReasonerUtil.toString(ReasonerUtil.toDNF(term, true)));
    }

    private static void testDNFandCNFs() {
        PrimitiveConcept prim1 = TermFactory.instance().createPrim("1");
        PrimitiveConcept prim2 = TermFactory.instance().createPrim("2");
        PrimitiveConcept prim3 = TermFactory.instance().createPrim("3");
        Intersection and1 = TermFactory.instance().createIntersect(prim1, prim2);
        Intersection and2 = TermFactory.instance().createIntersect(prim1, prim2);
        and2.addIntersectOf(prim3);
        Union term = TermFactory.instance().createUnion(and1, and2);
        System.out.println("Orignal: " + ReasonerUtil.toString(term));
        System.out.println("toDNF: " + ReasonerUtil.toString(ReasonerUtil.toDNF(term, true)));
        System.out.println("toCNF: " + ReasonerUtil.toString(ReasonerUtil.toCNF(term, true)));
    }

    public static Role getRandomProperty() {
        ObjectProp r = TermFactory.instance().createObjectProp(String.valueOf((char)(82 + random.nextInt(3))));
        return r;
    }

    public static Concept createRandomClass(int size) {
        List l;
        Concept c;
        if (size == 1) {
            if (random.nextInt(16) == 0) {
                if (random.nextBoolean()) {
                    return ReasonerUtil.cloneConcept(ReasonerUtil.TOP);
                }
                return ReasonerUtil.cloneConcept(ReasonerUtil.BOTTOM);
            }
            PrimitiveConcept c2 = TermFactory.instance().createPrim("C" + String.valueOf(index++));
            return c2;
        }
        if (size == 2 || random.nextInt(10) < 4) {
            if (random.nextBoolean()) {
                AllValueFrom c3 = TermFactory.instance().createAll(Test.getRandomProperty(), Test.createRandomClass(size - 1));
                return c3;
            }
            SomeValueFrom c4 = TermFactory.instance().createSome(Test.getRandomProperty(), Test.createRandomClass(size - 1));
            return c4;
        }
        if (random.nextBoolean()) {
            c = TermFactory.instance().createIntersect();
            l = ((Intersection)c).getIntersectOf();
        } else {
            c = TermFactory.instance().createUnion();
            l = ((Union)c).getUnionOf();
        }
        int r = random.nextInt(sum[--size][1] - 1);
        int min = 1;
        block0: while (size > 0) {
            int i = min;
            while (i <= size) {
                if (r < sum[size][i] - sum[size][i + 1]) {
                    l.add(Test.createRandomClass(i));
                    size -= i;
                    min = i;
                    continue block0;
                }
                r -= sum[size][i] - sum[size][i + 1];
                ++i;
            }
        }
        return c;
    }

    public static void show(TBox tbox) {
        int size = tbox.nodeList.size();
        int[][] containments = new int[size][size];
        int i = 0;
        while (i < size) {
            System.out.print("Node No." + i + ":  ");
            CTNode node = (CTNode)tbox.nodeList.get(i);
            Iterator iter = node.getCIDSet().iterator();
            while (iter.hasNext()) {
                System.out.println(ReasonerUtil.toString(tbox.getConceptByID((Integer)iter.next())));
            }
            iter = node.containmentLinks.iterator();
            while (iter.hasNext()) {
                int[] nArray = containments[i];
                int n = ((ContainmentLink)iter.next()).getTarget().topologicalPosition;
                nArray[n] = nArray[n] + 1;
            }
            System.out.println("-----------------------------------------");
            ++i;
        }
        MyNumberFormat format = new MyNumberFormat(3);
        int i2 = 0;
        while (i2 < size) {
            System.out.print(String.valueOf(format.format(i2)) + "|");
            int j = 0;
            while (j < size) {
                System.out.print(format.format(containments[i2][j]));
                ++j;
            }
            System.out.println();
            ++i2;
        }
        System.out.print("   +");
        i2 = 0;
        while (i2 < size) {
            System.out.print("---");
            ++i2;
        }
        System.out.println("--");
        System.out.print("    ");
        i2 = 0;
        while (i2 < size) {
            System.out.print(format.format(i2));
            ++i2;
        }
        System.out.println();
    }

    private static class MyNumberFormat {
        private int length;

        public MyNumberFormat(int length) {
            this.length = length;
        }

        public String format(int number) {
            String s = String.valueOf(number);
            if (s.length() < this.length) {
                StringBuffer sb = new StringBuffer();
                int i = s.length();
                while (i < this.length) {
                    sb.append(' ');
                    ++i;
                }
                sb.append(s);
                return sb.toString();
            }
            return s;
        }
    }
}

