/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.create;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.InteractionOperatorKind;

public class ChooseOperatorDialog
extends Dialog {
    private OperatorProperties myResult;
    private ChooseOperatorPanel myChooseOperatorPanel;
    private final InteractionOperatorKind[] myOperatorInfos;

    public ChooseOperatorDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67696);
        this.myOperatorInfos = InteractionOperatorKind.VALUES.toArray(new InteractionOperatorKind[InteractionOperatorKind.VALUES.size()]);
        Arrays.sort(this.myOperatorInfos);
    }

    OperatorProperties getResult() {
        return this.myResult;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("New Combined Fragment");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createChooseOperatorPanel(composite);
        return composite;
    }

    protected void okPressed() {
        this.myResult = this.myChooseOperatorPanel.getPropertyEditor().getResult();
        super.okPressed();
    }

    private void createChooseOperatorPanel(Composite composite) {
        this.myChooseOperatorPanel = new ChooseOperatorPanel(composite);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.myChooseOperatorPanel.getRootControl().setLayoutData((Object)gd);
    }

    private IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ChooseOperatorDialog.this.myOperatorInfos;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private static boolean hasSingleOperand(InteractionOperatorKind kind) {
        switch (kind.getValue()) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    private static boolean hasArguments(InteractionOperatorKind kind) {
        switch (kind.getValue()) {
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private static boolean isUMLcompliant(InteractionOperatorKind kind) {
        return true;
    }

    class ChooseOperatorPanel {
        private final Group myPanel;
        private ListViewer myListViewer;
        private OperatorPropertyEditor myPropertyEditor;
        private List myList;

        public ChooseOperatorPanel(Composite parent) {
            this.myPanel = new Group(parent, 0);
            this.myPanel.setText("Combined Fragment Options");
            this.myPanel.setLayout((Layout)new GridLayout(2, false));
            this.createOperatorsList();
            this.createOperatorPropertyEditor();
            this.myList.setSelection(0);
            this.myPropertyEditor.setCurrentOperatorInfo(ChooseOperatorDialog.this.myOperatorInfos[0]);
        }

        Control getRootControl() {
            return this.myPanel;
        }

        OperatorPropertyEditor getPropertyEditor() {
            return this.myPropertyEditor;
        }

        private void createOperatorsList() {
            this.myList = new List((Composite)this.myPanel, 2560);
            GridData gd = new GridData(1040);
            gd.widthHint = 90;
            this.myList.setLayoutData((Object)gd);
            this.myList.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ChooseOperatorPanel.this.updateSelectedOperator();
                }
            });
            this.myList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseOperatorPanel.this.updateSelectedOperator();
                }
            });
            this.myListViewer = new ListViewer(this.myList);
            this.myListViewer.setContentProvider((IContentProvider)ChooseOperatorDialog.this.getContentProvider());
            this.myListViewer.setLabelProvider((IBaseLabelProvider)new OperatorNameLabelProvider());
            this.myListViewer.setInput((Object)Collections.EMPTY_SET);
        }

        private void createOperatorPropertyEditor() {
            this.myPropertyEditor = new OperatorPropertyEditor((Composite)this.myPanel);
            GridData gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            this.myPropertyEditor.setLayoutData(gd);
        }

        private void updateSelectedOperator() {
            int index = this.myList.getSelectionIndex();
            InteractionOperatorKind info = ChooseOperatorDialog.this.myOperatorInfos[index];
            this.myPropertyEditor.setCurrentOperatorInfo(info);
        }

        class OperatorNameLabelProvider
        extends LabelProvider
        implements IBaseLabelProvider {
            OperatorNameLabelProvider() {
            }

            public String getText(Object element) {
                InteractionOperatorKind info = (InteractionOperatorKind)element;
                return info.getName();
            }
        }

        class OperatorPropertyEditor
        extends Composite {
            private final Label myArgumentsLabel;
            private final Text myArgumentsText;
            private final Label myNumberOfOperandsLabel;
            private final Text myNumberOfOperandsText;
            private final Button myCancelUMLCheckBox;
            private final Label myCancelUMLLabel;
            private final Composite myCancelUMLPanel;
            private final Label myOperatorNameLabel;
            private final Text myOperatorNameText;
            private InteractionOperatorKind myCurrentInfo;

            public OperatorPropertyEditor(Composite parent) {
                super(parent, 0);
                this.setLayout((Layout)new GridLayout());
                this.myOperatorNameLabel = new Label((Composite)this, 0);
                GridData gd = new GridData(1);
                this.myOperatorNameLabel.setLayoutData((Object)gd);
                this.myOperatorNameLabel.setText("Operator name:");
                this.myOperatorNameText = new Text((Composite)this, 2048);
                gd = new GridData(768);
                this.myOperatorNameText.setLayoutData((Object)gd);
                this.myArgumentsLabel = new Label((Composite)this, 0);
                gd = new GridData(1);
                this.myArgumentsLabel.setLayoutData((Object)gd);
                this.myArgumentsLabel.setText("Arguments:");
                this.myArgumentsText = new Text((Composite)this, 2048);
                gd = new GridData(768);
                this.myArgumentsText.setLayoutData((Object)gd);
                this.myNumberOfOperandsLabel = new Label((Composite)this, 0);
                gd = new GridData(1);
                this.myNumberOfOperandsLabel.setLayoutData((Object)gd);
                this.myNumberOfOperandsLabel.setText("Number of operands:");
                this.myNumberOfOperandsText = new Text((Composite)this, 2048);
                gd = new GridData(768);
                this.myNumberOfOperandsText.setLayoutData((Object)gd);
                this.myNumberOfOperandsText.addListener(25, new Listener(){

                    public void handleEvent(Event e) {
                        if (OperatorPropertyEditor.this.myNumberOfOperandsText.getText().length() >= 2 && e.text.length() > 0) {
                            e.doit = false;
                            return;
                        }
                        String text = e.text;
                        char[] chars = new char[text.length()];
                        text.getChars(0, chars.length, chars, 0);
                        int i = 0;
                        while (i < chars.length) {
                            if ('0' > chars[i] || chars[i] > '9') {
                                e.doit = false;
                                return;
                            }
                            ++i;
                        }
                    }
                });
                this.myCancelUMLPanel = new Composite((Composite)this, 0);
                gd = new GridData(32);
                this.myCancelUMLPanel.setLayoutData((Object)gd);
                this.myCancelUMLPanel.setLayout((Layout)new GridLayout(2, false));
                this.myCancelUMLCheckBox = new Button(this.myCancelUMLPanel, 32);
                gd = new GridData(32);
                this.myCancelUMLCheckBox.setLayoutData((Object)gd);
                this.myCancelUMLCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        OperatorPropertyEditor.this.setUMLConstraints(OperatorPropertyEditor.this.myCancelUMLCheckBox.getSelection());
                    }
                });
                this.myCancelUMLLabel = new Label(this.myCancelUMLPanel, 0);
                gd = new GridData(32);
                this.myCancelUMLLabel.setLayoutData((Object)gd);
                this.myCancelUMLLabel.setText("Cancel UML limitations");
            }

            void setCurrentOperatorInfo(InteractionOperatorKind info) {
                this.myCurrentInfo = info;
                this.myCancelUMLCheckBox.setSelection(false);
                boolean operatorNameShouldBeSpecified = !this.operatorHasPredefinedName(info);
                this.myOperatorNameLabel.setVisible(operatorNameShouldBeSpecified);
                this.myOperatorNameText.setVisible(operatorNameShouldBeSpecified);
                this.myOperatorNameText.setText("");
                ((GridData)this.myOperatorNameLabel.getLayoutData()).exclude = !this.myOperatorNameLabel.isVisible();
                ((GridData)this.myOperatorNameText.getLayoutData()).exclude = !this.myOperatorNameText.isVisible();
                this.myArgumentsLabel.setEnabled(ChooseOperatorDialog.hasArguments(info));
                this.myArgumentsText.setEnabled(ChooseOperatorDialog.hasArguments(info));
                this.myArgumentsText.setText("");
                this.myNumberOfOperandsLabel.setEnabled(!ChooseOperatorDialog.hasSingleOperand(info));
                this.myNumberOfOperandsText.setEnabled(!ChooseOperatorDialog.hasSingleOperand(info));
                this.myNumberOfOperandsText.setText(ChooseOperatorDialog.hasSingleOperand(info) ? "1" : "2");
                this.myCancelUMLPanel.setVisible(ChooseOperatorDialog.isUMLcompliant(info));
                ((GridData)this.myCancelUMLPanel.getLayoutData()).exclude = !this.myCancelUMLPanel.getVisible();
                this.layout();
            }

            void setUMLConstraints(boolean cancel) {
                if (!cancel) {
                    this.myArgumentsText.setText("");
                    this.myNumberOfOperandsText.setText(ChooseOperatorDialog.hasSingleOperand(this.myCurrentInfo) ? "1" : "2");
                }
                this.myArgumentsLabel.setEnabled(cancel || ChooseOperatorDialog.hasArguments(this.myCurrentInfo));
                this.myArgumentsText.setEnabled(cancel || ChooseOperatorDialog.hasArguments(this.myCurrentInfo));
                this.myNumberOfOperandsLabel.setEnabled(cancel || !ChooseOperatorDialog.hasSingleOperand(this.myCurrentInfo));
                this.myNumberOfOperandsText.setEnabled(cancel || !ChooseOperatorDialog.hasSingleOperand(this.myCurrentInfo));
            }

            OperatorProperties getResult() {
                int operandsNumber;
                try {
                    operandsNumber = Integer.parseInt(this.myNumberOfOperandsText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    operandsNumber = ChooseOperatorDialog.hasSingleOperand(this.myCurrentInfo) ? 1 : 2;
                }
                OperatorProperties result = new OperatorProperties(this.myCurrentInfo, this.myArgumentsText.getText(), operandsNumber);
                return result;
            }

            boolean operatorHasPredefinedName(InteractionOperatorKind info) {
                return true;
            }
        }
    }

    static class OperatorProperties {
        private final InteractionOperatorKind myOperatorKind;
        private final String myArguments;
        private final int myNumberOfOperands;

        OperatorProperties(InteractionOperatorKind operatorKind, String arguments, int numberOfOperands) {
            this.myOperatorKind = operatorKind;
            this.myArguments = arguments;
            this.myNumberOfOperands = numberOfOperands;
        }

        String getArguments() {
            return this.myArguments;
        }

        int getNumberOfOperands() {
            return this.myNumberOfOperands;
        }

        InteractionOperatorKind getOperatorKind() {
            return this.myOperatorKind;
        }
    }
}

