/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsElementPropertyAccess;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;

public class MessageLabelLayouter {
    public static void layoutMessageLabelsVertically(AbsLink gdeLink, int yPos) {
        MessageLabel[] labels = MessageLabelLayouter.getLabels(gdeLink);
        int i = 0;
        while (i < labels.length) {
            MessageLabel next = labels[i];
            int height = next.getPreferredHeight();
            next.setY(yPos - height);
            ++i;
        }
    }

    public static void layoutMessageLabelsHorizontally(AbsLink gdeLink, int startXPos, int endXPos, boolean fullLayout) {
        if (startXPos <= endXPos) {
            int xPos = startXPos;
            MessageLabel[] labels = MessageLabelLayouter.getLabels(gdeLink);
            int i = 0;
            while (i < labels.length) {
                int width;
                MessageLabel next = labels[i];
                if (fullLayout || !next.isUserResized()) {
                    next.setX(xPos);
                    width = next.getPreferredWidth();
                } else {
                    width = next.getWidth();
                }
                xPos += width;
                ++i;
            }
        } else {
            MessageLabel[] labels = MessageLabelLayouter.getLabels(gdeLink);
            int[] widths = new int[labels.length];
            int sumWidth = 0;
            int i = 0;
            while (i < widths.length) {
                MessageLabel next = labels[i];
                int width = fullLayout || !next.isUserResized() ? next.getPreferredWidth() : next.getWidth();
                widths[i] = width;
                sumWidth += widths[i];
                ++i;
            }
            int xPos = startXPos - sumWidth;
            int i2 = 0;
            while (i2 < widths.length) {
                MessageLabel next = labels[i2];
                if (fullLayout || !next.isUserResized()) {
                    next.setX(xPos);
                }
                xPos += widths[i2];
                ++i2;
            }
        }
    }

    private static MessageLabel[] getLabels(AbsLink absLink) {
        return AbsElementPropertyAccess.getInstance().getLabels(absLink);
    }

    public static interface MessageLabel {
        public boolean isUserResized();

        public int getPreferredHeight();

        public int getPreferredWidth();

        public int getWidth();

        public void setY(int var1);

        public void setX(int var1);
    }
}

