/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.console;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class BuilderConsole
extends IOConsole
implements IBuildConsoleProxy {
    private static final String CONSOLE_TYPE = "MTJBuildConsole";
    private IConsoleColorProvider colorProvider = new ConsoleColorProvider();
    private Map<IBuildConsoleProxy.Stream, Color> colors;
    private Map<IBuildConsoleProxy.Stream, PrintWriter> writers;

    public BuilderConsole() {
        super(MTJUIMessages.BuilderConsole_name, CONSOLE_TYPE, null, true);
        BuildConsoleProxy.getInstance().setProxy((IBuildConsoleProxy)this);
        this.writers = new HashMap<IBuildConsoleProxy.Stream, PrintWriter>(3);
        this.colors = new HashMap<IBuildConsoleProxy.Stream, Color>(3);
        this.colors.put(IBuildConsoleProxy.Stream.ERROR, this.colorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM"));
        this.colors.put(IBuildConsoleProxy.Stream.OUTPUT, this.colorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM"));
        this.colors.put(IBuildConsoleProxy.Stream.TRACE, new Color((Device)Display.getDefault(), 0, 128, 128));
    }

    public PrintWriter getConsoleWriter(IBuildConsoleProxy.Stream stream) {
        PrintWriter printWriter = this.writers.get(stream);
        if (printWriter == null) {
            final Color color = this.getColor(stream);
            final IOConsoleOutputStream iOConsoleOutputStream = this.newOutputStream();
            printWriter = new PrintWriter((OutputStream)iOConsoleOutputStream);
            this.writers.put(stream, printWriter);
            if (color != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        iOConsoleOutputStream.setColor(color);
                    }
                });
            }
        }
        return printWriter;
    }

    private Color getColor(IBuildConsoleProxy.Stream stream) {
        return this.colors.get(stream);
    }
}

