/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.devices.DeviceImportWizardPage;

public class DeviceImportWizard
extends Wizard {
    private DeviceImportWizardPage wizardPage;

    public DeviceImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(MTJUIMessages.DeviceImportWizard_title);
        this.setDialogSettings(MTJUIPlugin.getDialogSettings(((Object)((Object)this)).getClass().getName()));
    }

    public void addPages() {
        this.wizardPage = new DeviceImportWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        boolean bl = false;
        MTJCore.getDeviceRegistry().enableDeviceAddedEvent(true);
        IDevice[] iDeviceArray = this.wizardPage.getSelectedDevices();
        int n = 0;
        while (n < iDeviceArray.length) {
            IDevice iDevice = iDeviceArray[n];
            try {
                MTJCore.getDeviceRegistry().addDevice(iDevice);
                bl = true;
            }
            catch (Exception exception) {
                MTJLogger.log((int)2, (String)MTJUIMessages.DeviceImportWizard_error_adding_new_device, (Throwable)exception);
                MTJUIPlugin.displayError(this.getShell(), 2, -999, MTJUIMessages.DeviceImportWizard_erro_dialog_title, MTJUIMessages.DeviceImportWizard_error_dialog_message, exception);
            }
            ++n;
        }
        return bl;
    }
}

