/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.mtj.internal.ui.editor.IMTJDropParticipant;
import org.eclipse.mtj.internal.ui.editor.IMTJSourceParticipant;
import org.eclipse.mtj.internal.ui.editor.ModelDataTransfer;
import org.eclipse.swt.dnd.TransferData;

public class MTJDropAdapter
extends ViewerDropAdapter {
    private IMTJDropParticipant fDropParticipant;
    private IMTJSourceParticipant fSourceParticipant;
    private int fLastValidOperation;

    public MTJDropAdapter(Viewer viewer, IMTJDropParticipant iMTJDropParticipant, IMTJSourceParticipant iMTJSourceParticipant) {
        super(viewer);
        this.fDropParticipant = iMTJDropParticipant;
        this.fSourceParticipant = iMTJSourceParticipant;
        this.resetLastValidOperation();
    }

    protected void resetLastValidOperation() {
        this.fLastValidOperation = 0;
    }

    protected int getLastValidOperation(int n) {
        if (n != 0) {
            this.fLastValidOperation = n;
        }
        return this.fLastValidOperation;
    }

    public boolean performDrop(Object object) {
        this.resetLastValidOperation();
        Object object2 = this.getCurrentTarget();
        int n = this.getCurrentLocation();
        Object[] objectArray = null;
        objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        int n2 = this.getCurrentOperation();
        if (n2 == 1) {
            this.fDropParticipant.doDropCopy(object2, objectArray, n);
        } else if (n2 == 2) {
            this.fDropParticipant.doDropMove(object2, objectArray, n);
        } else if (n2 == 4) {
            this.fDropParticipant.doDropLink(object2, objectArray, n);
        } else if (n2 == 16) {
            this.fDropParticipant.doDropMove(object2, objectArray, n);
        } else {
            return false;
        }
        return true;
    }

    public boolean validateDrop(Object object, int n, TransferData transferData) {
        n = this.getLastValidOperation(n);
        object = this.getCurrentTarget();
        int n2 = this.getCurrentLocation();
        if (!ModelDataTransfer.getInstance().isSupportedType(transferData)) {
            return false;
        }
        if (n2 == 4) {
            return false;
        }
        Object[] objectArray = this.fSourceParticipant.getSourceObjects();
        if (objectArray == null) {
            return false;
        }
        if (objectArray.length == 0) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (n == 1) {
            return this.validateDropCopy(object, objectArray, n2);
        }
        if (n == 2) {
            return this.validateDropMove(object, objectArray, n2);
        }
        if (n == 4) {
            return this.validateDropLink(object, objectArray, n2);
        }
        if (n == 16) {
            return this.validateDropDefault(object, objectArray, n2);
        }
        return false;
    }

    protected boolean validateDropCopy(Object object, Object[] objectArray, int n) {
        return this.fDropParticipant.canDropCopy(object, objectArray, n);
    }

    protected boolean validateDropMove(Object object, Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (object.equals(objectArray[n2])) {
                return false;
            }
            ++n2;
        }
        return this.fDropParticipant.canDropMove(object, objectArray, n);
    }

    protected boolean validateDropLink(Object object, Object[] objectArray, int n) {
        return this.fDropParticipant.canDropLink(object, objectArray, n);
    }

    protected boolean validateDropDefault(Object object, Object[] objectArray, int n) {
        return this.validateDropMove(object, objectArray, n);
    }
}

