/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesPage;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesSourcePage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class BuildPropertiesEditor
extends FormEditor {
    private IMTJProject mtjProject;
    private List<IFormPage> pages = new ArrayList<IFormPage>();
    private IFile file;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)iEditorInput).getFile();
            IJavaProject iJavaProject = JavaCore.create((IProject)this.file.getProject());
            if (iJavaProject != null) {
                this.mtjProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
            }
        }
    }

    protected void addPages() {
        if (this.mtjProject != null) {
            try {
                MTJBuildProperties mTJBuildProperties = MTJBuildProperties.getBuildProperties((IMTJProject)this.mtjProject);
                BuildPropertiesPage buildPropertiesPage = new BuildPropertiesPage(this, mTJBuildProperties);
                this.addPage((IFormPage)buildPropertiesPage);
                BuildPropertiesSourcePage buildPropertiesSourcePage = new BuildPropertiesSourcePage(this, mTJBuildProperties);
                this.addPage((IFormPage)buildPropertiesSourcePage);
                this.pages.add((IFormPage)buildPropertiesPage);
                this.pages.add((IFormPage)buildPropertiesSourcePage);
            }
            catch (PartInitException partInitException) {
                MTJLogger.log((int)4, (Throwable)partInitException);
            }
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        for (IFormPage iFormPage : this.pages) {
            iFormPage.doSave(iProgressMonitor);
        }
    }

    public void doSaveAs() {
        for (IFormPage iFormPage : this.pages) {
            iFormPage.doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

